/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.appease;

import com.hungteen.pvz.common.entity.plant.appease.PeaShooterEntity;
import com.hungteen.pvz.utils.AnimationUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.world.World;

public class ThreePeaterEntity
extends PeaShooterEntity {
    private static final double RIGHT_OFFSET = 0.6;
    private static final double DOWN_OFFSET = -0.35;
    private static final int SUPER_CD = 100;

    public ThreePeaterEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public void shootBullet() {
        if (this.isPlantInSuperMode()) {
            int tick = 100 - this.getSuperTime() % 100;
            double angle = AnimationUtil.upDown(tick, 100.0f, 60.0f);
            this.performShoot(0.2, 0.0, 0.0, this.getExistTick() % 10 == 0, 0.0);
            this.performShoot(0.2, -0.6, -0.35, false, -angle);
            this.performShoot(0.2, 0.6, -0.35, false, angle);
        } else {
            this.performShoot(0.2, 0.0, 0.0, true, 0.0);
            this.performShoot(0.2, -0.6, -0.35, false, -7.5);
            this.performShoot(0.2, 0.6, -0.35, false, 7.5);
        }
    }

    @Override
    public int getSuperTimeLength() {
        return (this.isPlantInStage(1) ? 1 : (this.isPlantInStage(2) ? 2 : 3)) * 100;
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        return new EntitySize(0.9f, 1.7f, false);
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.THREE_PEATER;
    }
}

