/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.assist;

import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.entity.plant.base.PlantBomberEntity;
import com.hungteen.pvz.common.entity.zombie.poolnight.BalloonZombieEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.MathUtil;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.PlayerUtil;
import com.hungteen.pvz.utils.enums.Plants;
import com.hungteen.pvz.utils.enums.Resources;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class BloverEntity
extends PlantBomberEntity {
    public BloverEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public void startBomb(boolean server) {
    }

    @Override
    protected void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K && this.getAttackTime() == 5) {
            this.blow();
        }
    }

    public void blow() {
        if (!this.field_70170_p.field_72995_K) {
            float len = 30.0f;
            EntityUtil.getTargetableLivings((Entity)this, EntityUtil.getEntityAABB((Entity)this, 30.0, 30.0)).forEach(target -> {
                if (EntityUtil.isEntityInSky((Entity)target)) {
                    target.func_70097_a((DamageSource)PVZDamageSource.normal((Entity)this).setMustHurt(), this.getAttackDamage());
                    Vector3d speed = target.func_213322_ci();
                    double lvl = (float)this.getForceLevel() * 2.5f;
                    Vector3d delta = MathUtil.getHorizontalNormalizedVec(this.func_213303_ch(), target.func_213303_ch()).func_186678_a(lvl);
                    target.func_213293_j(speed.field_72450_a + delta.field_72450_a, speed.field_72448_b, speed.field_72449_c + delta.field_72449_c);
                }
            });
            this.field_70170_p.func_175647_a(PlayerEntity.class, EntityUtil.getEntityAABB((Entity)this, 30.0, 30.0), player -> !EntityUtil.canTargetEntity((Entity)this, (Entity)player)).forEach(player -> PlayerUtil.addPlayerStats(player, Resources.NO_FOG_TICK, 2400 * this.getForceLevel()));
        }
    }

    @Override
    public boolean canPlantTarget(Entity entity) {
        if (entity instanceof BalloonZombieEntity) {
            return true;
        }
        return super.canPlantTarget(entity);
    }

    @Override
    protected SoundEvent getSpawnSound() {
        return (SoundEvent)SoundRegister.BLOVER.get();
    }

    public float getAttackDamage() {
        return PlantUtil.getPlantAverageProgress((PVZPlantEntity)this, 10, 50);
    }

    public int getForceLevel() {
        return this.isPlantInStage(1) ? 1 : (this.isPlantInStage(2) ? 2 : 3);
    }

    @Override
    public int getReadyTime() {
        return 40;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.5f, (float)1.5f);
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.BLOVER;
    }
}

