/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.assist;

import com.hungteen.pvz.common.entity.drop.CoinEntity;
import com.hungteen.pvz.common.entity.drop.DropEntity;
import com.hungteen.pvz.common.entity.drop.JewelEntity;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.MathUtil;
import com.hungteen.pvz.utils.PlayerUtil;
import com.hungteen.pvz.utils.enums.Plants;
import com.hungteen.pvz.utils.enums.Resources;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class GoldMagnetEntity
extends PVZPlantEntity {
    private final Set<DropEntity> coinSet = new HashSet<DropEntity>();
    private static final int SEARCH_CD = 60;

    public GoldMagnetEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K) {
            this.tickCoinSet();
            this.setAttackTime(this.coinSet.size());
        }
    }

    private void tickCoinSet() {
        HashSet tmp = new HashSet();
        this.coinSet.forEach(coin -> {
            if (EntityUtil.isEntityValid((Entity)coin) && coin.getDropState() == DropEntity.DropStates.ABSORB) {
                tmp.add(coin);
            }
        });
        this.coinSet.clear();
        this.coinSet.addAll(tmp);
        tmp.clear();
        if (!this.checkCanWorkNow()) {
            this.coinSet.forEach(coin -> coin.setDropState(DropEntity.DropStates.NORMAL));
            this.coinSet.clear();
            return;
        }
        if (this.getExistTick() % 60 == 0) {
            float range = this.getSearchRange();
            this.field_70170_p.func_175647_a(DropEntity.class, EntityUtil.getEntityAABB((Entity)this, range, range), drop -> (drop instanceof CoinEntity || drop instanceof JewelEntity) && drop.getDropState() == DropEntity.DropStates.NORMAL && !this.coinSet.contains(drop)).forEach(coin -> {
                coin.setDropState(DropEntity.DropStates.ABSORB);
                this.coinSet.add((DropEntity)((Object)coin));
            });
            if (!this.coinSet.isEmpty()) {
                EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.MAGNET.get());
            }
        }
        this.coinSet.forEach(coin -> {
            double speed = 0.35;
            Vector3d now = new Vector3d(this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_213302_cg(), this.func_226281_cx_());
            Vector3d vec = now.func_178788_d(coin.func_213303_ch());
            if (vec.func_72433_c() <= 1.0) {
                this.onCollectCoin((DropEntity)((Object)coin));
            } else {
                coin.func_213317_d(vec.func_72432_b().func_186678_a(0.35));
            }
        });
    }

    protected void onCollectCoin(DropEntity drop) {
        this.getOwnerPlayer().ifPresent(player -> {
            if (drop instanceof CoinEntity) {
                PlayerUtil.addPlayerStats(player, Resources.MONEY, drop.getAmount());
                EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.COIN_PICK.get());
            } else if (drop instanceof JewelEntity) {
                PlayerUtil.addPlayerStats(player, Resources.GEM_NUM, drop.getAmount());
                EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.JEWEL_PICK.get());
            }
        });
        drop.func_70106_y();
    }

    public int getSearchRange() {
        return MathUtil.getProgressByDif(4, 2, this.getPlantLvl(), 20, 8, 16);
    }

    protected boolean checkCanWorkNow() {
        return this.ownerPlayer != null;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.5f, (float)1.3f);
    }

    @Override
    public int getSuperTimeLength() {
        return 0;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.GOLD_MAGNET;
    }
}

