/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.assist;

import com.hungteen.pvz.common.entity.ai.goal.target.PVZNearestTargetGoal;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.entity.zombie.grassnight.AbstractTombStoneEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.MathUtil;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class GraveBusterEntity
extends PVZPlantEntity {
    private static final int MAX_LIVE_TICK = 100;
    private int killCount = 0;

    public GraveBusterEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
        this.canCollideWithPlant = false;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new PVZNearestTargetGoal((MobEntity)this, true, false, 5.0f, 5.0f));
        this.field_70714_bg.func_75776_a(0, (Goal)new EatTombStoneGoal(this));
    }

    @Override
    protected void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K) {
            if (this.isEatingTomb()) {
                if (this.getAttackTime() % 20 == 10) {
                    EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.EAT.get());
                }
                this.setExistTick(0);
            }
            if (this.getExistTick() > 100) {
                this.func_70106_y();
            }
        }
    }

    @Override
    public void startSuperMode(boolean first) {
        super.startSuperMode(first);
        float range = 10.0f;
        int cnt = this.getSuperAttackCnt();
        for (LivingEntity target : EntityUtil.getTargetableLivings((Entity)this, EntityUtil.getEntityAABB((Entity)this, 10.0, 10.0))) {
            if (!(target instanceof AbstractTombStoneEntity)) continue;
            GraveBusterEntity buster = (GraveBusterEntity)((EntityType)EntityRegister.GRAVE_BUSTER.get()).func_200721_a(this.field_70170_p);
            PlantUtil.copyPlantData(buster, this);
            EntityUtil.onEntitySpawn((IWorld)this.field_70170_p, (Entity)buster, target.func_233580_cy_());
            buster.func_184220_m((Entity)target);
            buster.func_70624_b(target);
            if (--cnt != 0) continue;
            break;
        }
    }

    public boolean isEatingTomb() {
        return this.getAttackTime() > 0 && this.func_184187_bx() instanceof AbstractTombStoneEntity;
    }

    public int getEatTombCD() {
        return PlantUtil.getPlantAverageProgress((PVZPlantEntity)this, 100, 20);
    }

    public int getMaxKillCnt() {
        return MathUtil.getProgressByDif(5, 1, this.getPlantLvl(), 20, 1, 4);
    }

    public int getSuperAttackCnt() {
        return this.isPlantInStage(1) ? 3 : (this.isPlantInStage(2) ? 4 : 5);
    }

    @Override
    public boolean canPlantTarget(Entity entity) {
        return entity instanceof AbstractTombStoneEntity && (entity.func_184188_bt().isEmpty() || entity.func_70028_i(this.func_184187_bx()));
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)1.0f, (float)1.6f);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("kill_cnt", this.killCount);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("kill_cnt")) {
            this.killCount = compound.func_74762_e("kill_cnt");
        }
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.GRAVE_BUSTER;
    }

    @Override
    public int getSuperTimeLength() {
        return 20;
    }

    static class EatTombStoneGoal
    extends Goal {
        private GraveBusterEntity buster;
        private LivingEntity target;

        public EatTombStoneGoal(GraveBusterEntity buster) {
            this.buster = buster;
        }

        public boolean func_75250_a() {
            LivingEntity target = this.buster.func_70638_az();
            if (this.buster.isEatingTomb()) {
                return true;
            }
            if (!EntityUtil.isEntityValid((Entity)target) || !this.buster.canPlantTarget((Entity)target)) {
                this.buster.func_70624_b(null);
                this.target = null;
                return false;
            }
            this.target = target;
            this.buster.func_184205_a((Entity)this.target, true);
            return true;
        }

        public void func_75251_c() {
            this.target = null;
        }

        public boolean func_75253_b() {
            return this.buster.isEatingTomb();
        }

        public void func_75246_d() {
            if (!this.buster.canPlantNormalUpdate()) {
                return;
            }
            int tick = this.buster.getAttackTime();
            if (tick >= this.buster.getEatTombCD()) {
                this.buster.setAttackTime(0);
                ++this.buster.killCount;
                this.target.func_70097_a((DamageSource)PVZDamageSource.eat((Entity)this.buster), EntityUtil.getMaxHealthDamage(this.buster.func_70638_az(), 1.5f));
                if (this.buster.killCount >= this.buster.getMaxKillCnt()) {
                    this.buster.func_70106_y();
                }
            } else {
                this.buster.setAttackTime(tick + 1);
            }
        }
    }
}

