/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.assist;

import com.hungteen.pvz.PVZMod;
import com.hungteen.pvz.common.entity.ai.goal.target.PVZNearestTargetGoal;
import com.hungteen.pvz.common.entity.ai.goal.target.PVZTargetGoal;
import com.hungteen.pvz.common.entity.bullet.itembullet.MetalItemEntity;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.AlgorithmUtil;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.enums.MetalTypes;
import com.hungteen.pvz.utils.enums.Plants;
import com.hungteen.pvz.utils.interfaces.IHasMetal;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class MagnetShroomEntity
extends PVZPlantEntity {
    private static final DataParameter<Integer> METAL_TYPE = EntityDataManager.func_187226_a(MagnetShroomEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public MagnetShroomEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(METAL_TYPE, (Object)MetalTypes.EMPTY.ordinal());
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(0, (Goal)new PVZNearestTargetGoal((MobEntity)this, true, false, 12.0f, 12.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new TargetLadderGoal((MobEntity)this, true, false, 20.0f));
    }

    @Override
    protected void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K) {
            if (this.getAttackTime() > 0) {
                this.setAttackTime(this.getAttackTime() - 1);
            } else if (this.getAttackTime() == 0) {
                this.setMetalType(MetalTypes.EMPTY);
            }
            LivingEntity target = this.func_70638_az();
            if (EntityUtil.isEntityValid((Entity)target) && this.isMagnetActive()) {
                this.dragMetal(target);
            }
        }
    }

    @Override
    public void startSuperMode(boolean first) {
        super.startSuperMode(first);
        int range = 20;
        int cnt = this.getSuperDragCnt();
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.MAGNET.get());
        for (LivingEntity target : this.field_70170_p.func_175647_a(LivingEntity.class, EntityUtil.getEntityAABB((Entity)this, range, range), entity -> this.checkCanPlantTarget((Entity)entity))) {
            if (!(target instanceof IHasMetal)) continue;
            ((IHasMetal)target).decreaseMetal();
            MetalItemEntity metal = new MetalItemEntity(this.field_70170_p, (LivingEntity)this, ((IHasMetal)target).getMetalType());
            metal.setMetalState(MetalItemEntity.MetalStates.BULLET);
            metal.func_70107_b(target.func_226277_ct_(), target.func_226278_cu_() + (double)target.func_70047_e(), target.func_226281_cx_());
            metal.summonByOwner((Entity)this);
            metal.setAttackDamage(this.getAttackDamage());
            this.field_70170_p.func_217376_c((Entity)metal);
            if (--cnt != 0) continue;
            return;
        }
    }

    public void dragMetal(LivingEntity target) {
        if (target instanceof IHasMetal) {
            ((IHasMetal)target).decreaseMetal();
            this.setAttackTime(this.getAttackCD());
            MetalItemEntity metal = new MetalItemEntity(this.field_70170_p, (LivingEntity)this, ((IHasMetal)target).getMetalType());
            metal.func_70107_b(target.func_226277_ct_(), target.func_226278_cu_() + (double)target.func_70047_e(), target.func_226281_cx_());
            metal.summonByOwner((Entity)this);
            this.field_70170_p.func_217376_c((Entity)metal);
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.MAGNET.get());
        } else {
            PVZMod.LOGGER.warn("Wrong target for MagnetShroom.");
        }
    }

    public int getAttackDamage() {
        return this.isPlantInStage(1) ? 100 : (this.isPlantInStage(2) ? 200 : 300);
    }

    public int getSuperDragCnt() {
        return this.isPlantInStage(1) ? 3 : (this.isPlantInStage(2) ? 4 : 5);
    }

    public int getAttackCD() {
        return PlantUtil.getPlantAverageProgress((PVZPlantEntity)this, 600, 200);
    }

    public boolean isMagnetActive() {
        return this.getAttackTime() == 0;
    }

    public ItemStack getMetalRenderItem() {
        if (this.getMetalType() == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack((IItemProvider)MetalTypes.getMetalItem(this.getMetalType()));
    }

    @Override
    public boolean canPlantTarget(Entity entity) {
        return entity instanceof IHasMetal && ((IHasMetal)entity).hasMetal();
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("metal_type", this.getMetalType().ordinal());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("metal_type")) {
            this.setMetalType(MetalTypes.values()[compound.func_74762_e("metal_type")]);
        }
    }

    @Override
    public MetalTypes getMetalType() {
        return MetalTypes.values()[(Integer)this.field_70180_af.func_187225_a(METAL_TYPE)];
    }

    public void setMetalType(MetalTypes type) {
        this.field_70180_af.func_187227_b(METAL_TYPE, (Object)type.ordinal());
    }

    @Override
    public Plants getUpgradePlantType() {
        return Plants.GOLD_MAGNET;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.5f, (float)1.3f);
    }

    @Override
    public int getSuperTimeLength() {
        return 60;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.MAGNET_SHROOM;
    }

    private static class TargetLadderGoal
    extends PVZTargetGoal {
        protected final AlgorithmUtil.EntitySorter sorter;

        public TargetLadderGoal(MobEntity mobIn, boolean checkSight, boolean mustReach, float range) {
            super(mobIn, checkSight, mustReach, range, range);
            this.sorter = new AlgorithmUtil.EntitySorter((Entity)this.mob);
        }

        public boolean func_75250_a() {
            if (this.targetChance > 0 && this.mob.func_70681_au().nextInt(this.targetChance) != 0) {
                return false;
            }
            ArrayList list1 = new ArrayList();
            this.mob.field_70170_p.func_217357_a(PVZPlantEntity.class, this.getAABB()).forEach(plant -> {
                if (!EntityUtil.canTargetEntity((Entity)this.mob, (Entity)plant) && this.checkSenses((Entity)plant) && plant.hasMetal()) {
                    list1.add(plant);
                }
            });
            if (list1.isEmpty()) {
                return false;
            }
            Collections.sort(list1, this.sorter);
            this.targetMob = (LivingEntity)list1.get(0);
            return true;
        }

        @Override
        public boolean func_75253_b() {
            LivingEntity entity = this.mob.func_70638_az();
            if (entity == null) {
                entity = this.targetMob;
            }
            if (entity == null || !entity.func_70089_S()) {
                return false;
            }
            if (!EntityUtil.canTargetEntity((Entity)this.mob, (Entity)entity) && this.checkSenses((Entity)entity)) {
                this.mob.func_70624_b(entity);
                return true;
            }
            return false;
        }
    }
}

