/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.base;

import com.hungteen.pvz.common.entity.ai.goal.target.PVZNearestTargetGoal;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.utils.EntityUtil;
import javax.annotation.Nonnull;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public abstract class PlantCloserEntity
extends PVZPlantEntity {
    protected float closeWidth = 1.5f;
    protected float closeHeight = 1.5f;

    public PlantCloserEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(0, (Goal)new PVZNearestTargetGoal((MobEntity)this, true, false, this.getCloseWidth(), this.getCloseHeight()));
    }

    @Override
    protected void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K && this.canCheckDistance()) {
            if (EntityUtil.isEntityValid((Entity)this.func_70638_az())) {
                this.focusOnTarget(this.func_70638_az());
                int time = this.getAttackTime();
                if (time >= this.getAttackCD()) {
                    this.performAttack(this.func_70638_az());
                }
                this.setAttackTime(time + 1);
            } else {
                this.setAttackTime(0);
            }
        }
    }

    public void focusOnTarget(@Nonnull LivingEntity target) {
        this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
    }

    public boolean canCheckDistance() {
        return true;
    }

    public abstract void performAttack(LivingEntity var1);

    @Override
    public boolean isPlantImmuneTo(DamageSource source) {
        if (this.canBeImmuneToEnforce(source.func_76346_g())) {
            return super.isPlantImmuneTo(source) || PVZDamageSource.isEnforceDamage(source);
        }
        return super.isPlantImmuneTo(source);
    }

    protected boolean canBeImmuneToEnforce(Entity entity) {
        return this.checkCanPlantTarget(entity);
    }

    @Override
    public int getSuperTimeLength() {
        return 20;
    }

    public int getAttackCD() {
        return 10;
    }

    public float getCloseWidth() {
        return 1.5f;
    }

    public float getCloseHeight() {
        return 1.5f;
    }
}

