/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.base;

import com.hungteen.pvz.common.entity.drop.SunEntity;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.utils.EntityUtil;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public abstract class PlantProducerEntity
extends PVZPlantEntity {
    public PlantProducerEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
        this.setAttackTime(200);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new ProducerGenGoal(this));
    }

    protected void genSun(int num) {
        SunEntity sun = (SunEntity)((EntityType)EntityRegister.SUN.get()).func_200721_a(this.field_70170_p);
        sun.setAmount(num);
        EntityUtil.onMobEntityRandomPosSpawn((IWorld)this.field_70170_p, sun, this.func_233580_cy_(), 2);
        EntityUtil.playSound((Entity)this, SoundEvents.field_187604_bf);
    }

    protected abstract void genSomething();

    protected abstract void genSuper();

    public abstract int getGenCD();

    public int getAnimGenCD() {
        return 20;
    }

    @Override
    public int getSuperTimeLength() {
        return 30;
    }

    public boolean isPlantInGen() {
        return this.getAttackTime() <= 10 || this.isPlantInSuperMode() && this.getSuperTime() < 10;
    }

    static class ProducerGenGoal
    extends Goal {
        private final PlantProducerEntity producer;

        public ProducerGenGoal(PlantProducerEntity entity) {
            this.producer = entity;
        }

        public boolean func_75250_a() {
            return true;
        }

        public boolean func_75253_b() {
            return true;
        }

        public void func_75251_c() {
        }

        public void func_75246_d() {
            if (!this.producer.canPlantNormalUpdate()) {
                return;
            }
            if (this.producer.isPlantInSuperMode()) {
                if (this.producer.getSuperTime() == 1) {
                    this.producer.genSuper();
                }
                return;
            }
            int time = this.producer.getAttackTime();
            if (time <= 1) {
                this.producer.genSomething();
                this.producer.setAttackTime(this.producer.getGenCD());
            } else {
                this.producer.setAttackTime(Math.max(0, time - 1));
            }
        }
    }
}

