/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.base;

import com.hungteen.pvz.common.entity.ai.goal.attack.PultAttackGoal;
import com.hungteen.pvz.common.entity.ai.goal.target.PVZNearestTargetGoal;
import com.hungteen.pvz.common.entity.bullet.PultBulletEntity;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.interfaces.IPult;
import java.util.Optional;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public abstract class PlantPultEntity
extends PVZPlantEntity
implements IPult {
    protected boolean isSuperOut = false;

    public PlantPultEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new PultAttackGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new PVZNearestTargetGoal((MobEntity)this, true, false, this.getPultRange(), this.getPultHeight()));
    }

    @Override
    protected void updateAttributes() {
        super.updateAttributes();
        this.func_110148_a(Attributes.field_233819_b_).func_111128_a((double)this.getPultRange());
    }

    @Override
    protected void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K && this.getAttackTime() > 0) {
            this.setAttackTime(this.getAttackTime() - 1);
            if (this.getAttackTime() == this.getPultAnimTime() / 2) {
                if (this.isPlantInSuperMode() && !this.isSuperOut) {
                    this.isSuperOut = true;
                    this.superAttack();
                } else {
                    this.pultBullet();
                }
            }
        }
    }

    public void performPult(LivingEntity target1) {
        Optional.ofNullable(target1).ifPresent(target -> {
            PultBulletEntity bullet = this.createBullet();
            bullet.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)1.7f, this.func_226281_cx_());
            bullet.shootPultBullet((LivingEntity)target);
            bullet.summonByOwner((Entity)this);
            bullet.setAttackDamage(this.isPlantInSuperMode() ? this.getSuperDamage() : this.getAttackDamage());
            this.field_70170_p.func_217376_c((Entity)bullet);
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.PLANT_THROW.get());
        });
    }

    protected void superAttack() {
        float range = this.getSuperRange();
        EntityUtil.getTargetableLivings((Entity)this, EntityUtil.getEntityAABB((Entity)this, range, range)).forEach(target -> this.doSuperAttackToTarget((LivingEntity)target));
    }

    @Override
    public void pultBullet() {
        this.performPult(this.func_70638_az());
    }

    protected void doSuperAttackToTarget(LivingEntity target) {
        this.performPult(target);
    }

    protected abstract PultBulletEntity createBullet();

    public abstract float getSuperDamage();

    @Override
    public boolean shouldPult() {
        return this.canPlantNormalUpdate();
    }

    @Override
    public boolean canPlantTarget(Entity entity) {
        return this.checkY(entity) && super.canPlantTarget(entity);
    }

    protected boolean checkY(Entity target) {
        return this.func_226278_cu_() + (double)this.getPultHeight() >= target.func_226278_cu_() + (double)target.func_213302_cg();
    }

    public float getSuperRange() {
        return this.isPlantInStage(1) ? 15.0f : (this.isPlantInStage(2) ? 20.0f : 25.0f);
    }

    public float getAttackDamage() {
        return PlantUtil.getPlantAverageProgress((PVZPlantEntity)this, 2.0f, 8.0f);
    }

    @Override
    public float getPultRange() {
        return 30.0f;
    }

    public float getPultHeight() {
        return 15.0f;
    }

    @Override
    public void startPultAttack() {
        this.setAttackTime(this.getPultAnimTime());
    }

    @Override
    public void startSuperMode(boolean first) {
        super.startSuperMode(first);
        this.isSuperOut = false;
        this.startPultAttack();
    }

    public int getPultAnimTime() {
        return 20;
    }

    @Override
    public int getPultCD() {
        return 60;
    }

    @Override
    public int getSuperTimeLength() {
        return 60;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("is_plant_super_out")) {
            this.isSuperOut = compound.func_74767_n("is_plant_super_out");
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("is_plant_super_out", this.isSuperOut);
    }
}

