/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.base;

import com.hungteen.pvz.common.entity.ai.goal.target.PVZNearestTargetGoal;
import com.hungteen.pvz.common.entity.bullet.AbstractBulletEntity;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.entity.plant.appease.StarFruitEntity;
import com.hungteen.pvz.common.entity.plant.spear.CatTailEntity;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.MathUtil;
import com.hungteen.pvz.utils.interfaces.IShooter;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public abstract class PlantShooterEntity
extends PVZPlantEntity
implements IShooter {
    private static final DataParameter<Integer> SHOOT_TICK = EntityDataManager.func_187226_a(PVZPlantEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final float FORWARD_SHOOT_ANGLE = 0.0f;
    public static final float BACK_SHOOT_ANGLE = 180.0f;
    public static final float FORWARD_LEFT_SHOOT_ANGLE = -7.5f;
    public static final float FORWARD_RIGHT_SHOOT_ANGLE = 7.5f;
    public static final int SHOOT_ANIM_CD = 10;
    public static final int SHOOT_POINT = 7;
    public static final int SHOOT_POINT_OFFSET = 3;

    public PlantShooterEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SHOOT_TICK, (Object)0);
    }

    @Override
    protected void updateAttributes() {
        super.updateAttributes();
        this.func_110148_a(Attributes.field_233819_b_).func_111128_a((double)this.getShootRange());
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new ShooterAttackGoal(this));
        this.addTargetGoals();
    }

    protected void addTargetGoals() {
        this.field_70715_bh.func_75776_a(0, (Goal)new ShooterNearestTargetGoal(this, true, false, this.getShootRange(), this.getShootHeight()));
    }

    @Override
    public void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K && this.canAttackNow()) {
            this.shootBullet();
        }
        if (this.getAttackTime() > 0) {
            this.setAttackTime(this.getAttackTime() - 1);
        }
    }

    public void performShoot(double forwardOffset, double rightOffset, double heightOffset, boolean needSound, double angleOffset) {
        Optional.ofNullable(this.func_70638_az()).ifPresent(target -> {
            Vector3d vec = EntityUtil.getNormalisedVector2d((Entity)this, (Entity)target);
            double deltaY = (double)(this.func_213305_a((Pose)this.func_213283_Z()).field_220316_b * 0.7f) + heightOffset;
            double deltaX = forwardOffset * vec.field_72450_a - rightOffset * vec.field_72449_c;
            double deltaZ = forwardOffset * vec.field_72449_c + rightOffset * vec.field_72450_a;
            AbstractBulletEntity bullet = this.createBullet();
            bullet.func_70107_b(this.func_226277_ct_() + deltaX, this.func_226278_cu_() + deltaY, this.func_226281_cx_() + deltaZ);
            bullet.shootPea(vec.field_72450_a, target.func_226278_cu_() + (double)target.func_213302_cg() - bullet.func_226278_cu_(), vec.field_72449_c, this.getBulletSpeed(), angleOffset);
            if (needSound) {
                EntityUtil.playSound((Entity)this, this.getShootSound());
            }
            bullet.summonByOwner((Entity)this);
            bullet.setAttackDamage(this.getAttackDamage());
            this.field_70170_p.func_217376_c((Entity)bullet);
        });
    }

    public void shootByAngle(float angle, float height) {
        double vx = -MathHelper.func_76126_a((float)(angle *= 0.01745328f));
        double vz = MathHelper.func_76134_b((float)angle);
        AbstractBulletEntity bullet = this.createBullet();
        bullet.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)height, this.func_226281_cx_());
        bullet.func_213293_j(vx * (double)this.getBulletSpeed(), 0.0, vz * (double)this.getBulletSpeed());
        bullet.summonByOwner((Entity)this);
        bullet.setAttackDamage(this.getAttackDamage());
        this.field_70170_p.func_217376_c((Entity)bullet);
    }

    protected abstract AbstractBulletEntity createBullet();

    protected SoundEvent getShootSound() {
        return SoundEvents.field_187805_fE;
    }

    protected boolean canAttackNow() {
        return this.getAttackTime() > 0;
    }

    public float getAttackDamage() {
        return MathUtil.getProgressAverage(this.getPlantLvl(), 20, 1.0f, 4.0f);
    }

    @Override
    public boolean canPlantTarget(Entity entity) {
        return this.checkY(entity) && super.canPlantTarget(entity);
    }

    @Override
    public boolean checkY(Entity target) {
        double dx = target.func_226277_ct_() - this.func_226277_ct_();
        double dz = target.func_226281_cx_() - this.func_226281_cx_();
        double minY = target.func_226278_cu_() - this.func_226278_cu_() - (double)this.func_70047_e();
        double maxY = minY + (double)target.func_213302_cg();
        double dis = Math.sqrt(dx * dx + dz * dz);
        double y = dis / this.getMaxShootAngle();
        return minY < y && maxY > -y;
    }

    public double getMaxShootAngle() {
        return 60.0;
    }

    public float getShootRange() {
        return 30.0f;
    }

    public float getShootHeight() {
        return 2.0f;
    }

    public boolean canShoot() {
        return this.canPlantNormalUpdate();
    }

    @Override
    public int getShootCD() {
        return 30;
    }

    @Override
    public float getBulletSpeed() {
        return 1.5f;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("plant_shoot_tick")) {
            this.setShootTick(compound.func_74762_e("plant_shoot_tick"));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("plant_shoot_tick", this.getShootTick());
    }

    public int getShootTick() {
        return (Integer)this.field_70180_af.func_187225_a(SHOOT_TICK);
    }

    public void setShootTick(int tick) {
        this.field_70180_af.func_187227_b(SHOOT_TICK, (Object)tick);
    }

    protected static class ShooterNearestTargetGoal
    extends PVZNearestTargetGoal {
        private final PlantShooterEntity shooter;

        public ShooterNearestTargetGoal(PlantShooterEntity mobIn, boolean checkSight, boolean memory, float w, float h) {
            super((MobEntity)mobIn, checkSight, memory, w, h);
            this.shooter = mobIn;
        }

        @Override
        protected boolean checkOther(LivingEntity entity) {
            return super.checkOther(entity) && this.shooter.checkY((Entity)entity);
        }
    }

    static class ShooterAttackGoal
    extends Goal {
        protected final PlantShooterEntity shooter;
        protected LivingEntity target;

        public ShooterAttackGoal(PlantShooterEntity shooter) {
            this.shooter = shooter;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            if (!this.shooter.canShoot()) {
                this.shooter.setShootTick(0);
                return false;
            }
            this.target = this.shooter.func_70638_az();
            if (!this.checkTarget()) {
                this.target = null;
                this.shooter.func_70624_b(null);
                return false;
            }
            return true;
        }

        public boolean func_75253_b() {
            return this.func_75250_a();
        }

        public void func_75251_c() {
            this.shooter.setShootTick(0);
        }

        public void func_75246_d() {
            int T;
            if (!(this.shooter instanceof StarFruitEntity)) {
                this.shooter.func_70671_ap().func_75651_a((Entity)this.target, 30.0f, 30.0f);
            }
            if (this.shooter.isPlantInSuperMode()) {
                this.shooter.startShootAttack();
                this.shooter.setShootTick(0);
                return;
            }
            int time = this.shooter.getShootTick();
            if (time >= (T = this.shooter.getShootCD())) {
                this.shooter.setShootTick(0);
            } else {
                if (time == T - 3) {
                    this.shooter.startShootAttack();
                }
                this.shooter.setShootTick(time + 1);
            }
        }

        private boolean checkTarget() {
            if (EntityUtil.canAttackEntity((Entity)this.shooter, (Entity)this.target)) {
                if (this.shooter instanceof CatTailEntity) {
                    return EntityUtil.canSeeEntity((Entity)this.shooter, (Entity)this.target);
                }
                return this.shooter.func_70635_at().func_75522_a((Entity)this.target);
            }
            return false;
        }
    }
}

