/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.defence;

import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.entity.plant.base.PlantDefenderEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.AlgorithmUtil;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.enums.Plants;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class GarlicEntity
extends PlantDefenderEntity {
    protected final AlgorithmUtil.EntitySorter sorter = new AlgorithmUtil.EntitySorter((Entity)this);
    private GarlicEntity garlic;

    public GarlicEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source instanceof PVZDamageSource && ((PVZDamageSource)source).isEatDamage() && source.func_76346_g() instanceof MobEntity) {
            this.updateGarlic();
            if (this.garlic != null) {
                EntityUtil.playSound((Entity)((MobEntity)source.func_76346_g()), (SoundEvent)SoundRegister.YUCK.get());
                ((MobEntity)source.func_76346_g()).func_70624_b((LivingEntity)this.garlic);
            }
        }
        return super.func_70097_a(source, amount);
    }

    private void updateGarlic() {
        if (!EntityUtil.isEntityValid((Entity)this.garlic) || !this.func_70635_at().func_75522_a((Entity)this.garlic)) {
            this.garlic = null;
            float range = this.getChangeRange();
            List list = this.field_70170_p.func_175647_a(GarlicEntity.class, EntityUtil.getEntityAABB((Entity)this, range, range), target -> !target.func_70028_i((Entity)this) && EntityUtil.isEntityValid((Entity)target) && this.func_70635_at().func_75522_a((Entity)target) && !EntityUtil.canTargetEntity((Entity)this, (Entity)target));
            if (list.isEmpty()) {
                return;
            }
            Collections.sort(list, this.sorter);
            this.garlic = (GarlicEntity)list.get(0);
        }
    }

    public float getChangeRange() {
        return this.getThreeStage(10, 15, 20);
    }

    @Override
    public float getPlantHealth() {
        return PlantUtil.getPlantAverageProgress((PVZPlantEntity)this, 100, 400);
    }

    @Override
    public float getSuperLife() {
        return 0.0f;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.8f, (float)1.2f);
    }

    @Override
    public int getSuperTimeLength() {
        return 0;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.GARLIC;
    }
}

