/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.enforce;

import com.hungteen.pvz.common.entity.ai.goal.target.PVZNearestTargetGoal;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.entity.zombie.poolnight.BalloonZombieEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Plants;
import java.util.EnumSet;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class BonkChoyEntity
extends PVZPlantEntity {
    public BonkChoyEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new BonkChoyAttackGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new PVZNearestTargetGoal((MobEntity)this, true, false, 3.0f, 3.0f));
    }

    @Override
    protected void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K && this.isPlantInSuperMode() && this.getSuperTime() % 5 == 0) {
            float range = 5.0f;
            EntityUtil.getTargetableEntities((Entity)this, EntityUtil.getEntityAABB((Entity)this, 5.0, 5.0)).forEach(target -> {
                target.func_70097_a((DamageSource)PVZDamageSource.normal((Entity)this), this.getAttackDamage() * 5.0f);
                EntityUtil.spawnParticle(target, 7);
                EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.SWING.get());
            });
        }
    }

    public void attackTarget(LivingEntity target) {
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.SWING.get());
        EntityUtil.spawnParticle((Entity)target, 7);
        target.func_70097_a((DamageSource)PVZDamageSource.normal((Entity)this), this.getAttackDamage());
    }

    @Override
    public boolean canPlantTarget(Entity entity) {
        if (entity instanceof BalloonZombieEntity) {
            return true;
        }
        return super.canPlantTarget(entity);
    }

    public int getAttackCD() {
        return 10;
    }

    public float getAttackDamage() {
        return this.getAverageProgress(1.5f, 5.5f);
    }

    @Override
    public int getSuperTimeLength() {
        return this.getThreeStage(100, 150, 200);
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.BONK_CHOY;
    }

    private final class BonkChoyAttackGoal
    extends Goal {
        private final BonkChoyEntity attacker;

        public BonkChoyAttackGoal(BonkChoyEntity attacker) {
            this.attacker = attacker;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity living = this.attacker.func_70638_az();
            if (!EntityUtil.isEntityValid((Entity)living)) {
                return false;
            }
            return this.attacker.func_70685_l((Entity)living) && EntityUtil.getAttackRange((Entity)this.attacker, (Entity)living, 3.0) >= EntityUtil.getNearestDistance((Entity)this.attacker, (Entity)living);
        }

        public boolean func_75253_b() {
            LivingEntity living = this.attacker.func_70638_az();
            if (!EntityUtil.isEntityValid((Entity)living)) {
                return false;
            }
            return this.attacker.func_70685_l((Entity)living) && EntityUtil.getAttackRange((Entity)this.attacker, (Entity)living, 3.0) >= EntityUtil.getNearestDistance((Entity)this.attacker, (Entity)living);
        }

        public void func_75251_c() {
            this.attacker.func_70624_b(null);
            this.attacker.setAttackTime(0);
        }

        public void func_75246_d() {
            LivingEntity target = this.attacker.func_70638_az();
            this.attacker.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            if (this.attacker.getAttackTime() == 0) {
                if (this.attacker.getAttackDamage() >= EntityUtil.getCurrentHealth(target)) {
                    this.attacker.setAttackTime(1);
                } else {
                    this.attacker.setAttackTime(-1);
                }
            } else if (this.attacker.getAttackTime() > 0) {
                this.attacker.setAttackTime(this.attacker.getAttackTime() + 1);
                if (this.attacker.getAttackTime() == this.attacker.getAttackCD() * 4 / 5) {
                    this.attacker.attackTarget(target);
                } else if (this.attacker.getAttackTime() >= this.attacker.getAttackCD()) {
                    this.attacker.setAttackTime(0);
                }
            } else {
                this.attacker.setAttackTime(this.attacker.getAttackTime() - 1);
                if (-this.attacker.getAttackTime() == this.attacker.getAttackCD() * 4 / 5) {
                    this.attacker.attackTarget(target);
                } else if (-this.attacker.getAttackTime() >= this.attacker.getAttackCD()) {
                    this.attacker.setAttackTime(0);
                }
            }
        }
    }
}

