/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.enforce;

import com.hungteen.pvz.common.entity.ai.goal.target.PVZNearestTargetGoal;
import com.hungteen.pvz.common.entity.misc.SmallChomperEntity;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.MathUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class ChomperEntity
extends PVZPlantEntity {
    private static final DataParameter<Integer> REST_TICK = EntityDataManager.func_187226_a(ChomperEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final int ATTACK_ANIM_CD = 30;

    public ChomperEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(REST_TICK, (Object)0);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(0, (Goal)new PVZNearestTargetGoal((MobEntity)this, true, false, 3.0f, 2.0f));
    }

    @Override
    protected void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null) {
            this.field_70749_g.func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.getAttackTime() < 15) {
                if (this.getRestTick() > 0) {
                    this.setAttackTime(0);
                    this.setRestTick(this.getRestTick() - 1);
                    return;
                }
                if (!EntityUtil.isEntityValid((Entity)this.func_70638_az())) {
                    this.setAttackTime(0);
                    return;
                }
                this.setAttackTime(this.getAttackTime() + 1);
                if (this.getAttackTime() == 15) {
                    this.performAttack();
                }
            } else {
                this.setAttackTime(this.getAttackTime() + 1);
                if (this.getAttackTime() > 30) {
                    this.setAttackTime(0);
                }
            }
        }
    }

    @Override
    public void startSuperMode(boolean first) {
        super.startSuperMode(first);
        this.setRestTick(0);
        float range = 30.0f;
        int cnt = this.getSuperAttackCnt();
        for (LivingEntity target : EntityUtil.getTargetableLivings((Entity)this, EntityUtil.getEntityAABB((Entity)this, 30.0, 30.0))) {
            if (!target.func_233570_aj_()) continue;
            SmallChomperEntity chomper = (SmallChomperEntity)((EntityType)EntityRegister.SMALL_CHOMPER.get()).func_200721_a(this.field_70170_p);
            chomper.summonByOwner((Entity)this);
            EntityUtil.onEntitySpawn((IWorld)this.field_70170_p, chomper, target.func_233580_cy_());
            if (--cnt != 0) continue;
            break;
        }
    }

    protected void performAttack() {
        LivingEntity target = this.func_70638_az();
        float damage = this.getAttackDamage();
        if (EntityUtil.getCurrentHealth(target) <= this.getAttackDamage()) {
            target.func_70097_a((DamageSource)PVZDamageSource.eat((Entity)this), damage);
            this.setRestTick(this.getRestCD());
        } else {
            target.func_70097_a((DamageSource)PVZDamageSource.eat((Entity)this), damage / 50.0f);
        }
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.CHOMP.get());
    }

    public float getAttackDamage() {
        return MathUtil.getProgressAverage(this.getPlantLvl(), 20, 150, 250);
    }

    public int getRestCD() {
        return MathUtil.getProgressAverage(this.getPlantLvl(), 20, 840, 640);
    }

    public int getSuperAttackCnt() {
        return this.isPlantInStage(1) ? 3 : (this.isPlantInStage(2) ? 4 : 5);
    }

    public boolean isResting() {
        return this.getRestTick() > 0;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return new EntitySize(0.9f, 1.9f, false);
    }

    @Override
    public int getSuperTimeLength() {
        return 20;
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("rest_tick", this.getRestTick());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("rest_tick")) {
            this.setRestTick(compound.func_74762_e("rest_tick"));
        }
    }

    public int getRestTick() {
        return (Integer)this.field_70180_af.func_187225_a(REST_TICK);
    }

    public void setRestTick(int tick) {
        this.field_70180_af.func_187227_b(REST_TICK, (Object)tick);
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.CHOMPER;
    }
}

