/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.enforce;

import com.hungteen.pvz.common.entity.ai.goal.target.PVZRandomTargetGoal;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class SquashEntity
extends PVZPlantEntity {
    private static final int TARGET_RANGE = 3;
    protected int extraChance = 0;

    public SquashEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(0, (Goal)new PVZRandomTargetGoal((MobEntity)this, true, false, 3.0f, 3.0f));
    }

    @Override
    protected void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K) {
            if (EntityUtil.isEntityValid((Entity)this.func_70638_az())) {
                this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
            }
            if (this.getAttackTime() > 0) {
                if (this.func_233570_aj_() || this.func_203005_aq()) {
                    this.dealDamage();
                    if (this.extraChance > 0) {
                        --this.extraChance;
                    } else if (this.func_70681_au().nextInt(100) < this.getDeathChance()) {
                        this.func_70106_y();
                    }
                }
            } else if (this.func_70638_az() != null) {
                EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.SQUASH_HMM.get());
                this.jumpToTarget(this.func_70638_az());
            }
        }
    }

    @Override
    protected boolean shouldCollideWithEntity(LivingEntity target) {
        if (EntityUtil.canTargetEntity((Entity)this, (Entity)target)) {
            return false;
        }
        return super.shouldCollideWithEntity(target);
    }

    @Override
    public void startSuperMode(boolean first) {
        super.startSuperMode(first);
        if (!this.field_70170_p.field_72995_K) {
            this.extraChance += this.getSuperBonusChance();
        }
    }

    protected void dealDamage() {
        this.setAttackTime(0);
        this.canCollideWithPlant = true;
        this.isImmuneToWeak = false;
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.GROUND_SHAKE.get());
        float range = 1.0f;
        for (Entity entity : EntityUtil.getWholeTargetableEntities((Entity)this, EntityUtil.getEntityAABB((Entity)this, 1.0, 1.0))) {
            entity.func_70097_a((DamageSource)PVZDamageSource.causeCrushDamage((Entity)this), this.getAttackDamage());
        }
    }

    private void jumpToTarget(LivingEntity target) {
        int tick = 10;
        this.canCollideWithPlant = false;
        this.isImmuneToWeak = true;
        Vector3d pos = target.func_213303_ch().func_178787_e(target.func_213322_ci().func_186678_a(8.0));
        this.func_70107_b(pos.func_82615_a(), pos.func_82617_b() + (double)target.func_213302_cg() + 1.0, pos.func_82616_c());
        this.func_213293_j(this.func_213322_ci().func_82615_a(), 0.0, this.func_213322_ci().func_82616_c());
        this.setAttackTime(1);
    }

    @Override
    protected boolean shouldLockXZ() {
        return this.func_233570_aj_();
    }

    protected int getSuperBonusChance() {
        return this.isPlantInStage(1) ? 3 : (this.isPlantInStage(2) ? 4 : 5);
    }

    public float getAttackDamage() {
        return PlantUtil.getPlantAverageProgress((PVZPlantEntity)this, 125, 425);
    }

    public int getDeathChance() {
        return PlantUtil.getPlantAverageProgress((PVZPlantEntity)this, 90, 40);
    }

    @Override
    public boolean isPlantImmuneTo(DamageSource source) {
        return super.isPlantImmuneTo(source) || PVZDamageSource.isEnforceDamage(source);
    }

    @Override
    public int getSuperTimeLength() {
        return 20;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.9f, (float)1.5f);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("extra_chance")) {
            this.extraChance = compound.func_74762_e("extra_chance");
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("extra_chance", this.extraChance);
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.SQUASH;
    }
}

