/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.enforce;

import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.entity.plant.base.PlantCloserEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class TangleKelpEntity
extends PlantCloserEntity {
    public TangleKelpEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public void focusOnTarget(LivingEntity target) {
        super.focusOnTarget(target);
        if (target.func_184187_bx() == null) {
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.DRAG.get());
            this.func_70638_az().func_184205_a((Entity)this, true);
        }
        this.func_213293_j(0.0, -0.4f, 0.0);
    }

    @Override
    public void performAttack(LivingEntity target) {
        target.func_70097_a((DamageSource)PVZDamageSource.normal((Entity)this), this.getAttackDamage());
        this.func_70106_y();
    }

    @Override
    public void startSuperMode(boolean first) {
        super.startSuperMode(first);
        if (!this.field_70170_p.field_72995_K) {
            int cnt = this.getSuperCount();
            for (LivingEntity target : EntityUtil.getTargetableLivings((Entity)this, EntityUtil.getEntityAABB((Entity)this, 25.0, 3.0))) {
                TangleKelpEntity entity = (TangleKelpEntity)((EntityType)EntityRegister.TANGLE_KELP.get()).func_200721_a(this.field_70170_p);
                entity.func_70107_b(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
                PlantUtil.copyPlantData(entity, this);
                this.field_70170_p.func_217376_c((Entity)entity);
                entity.func_70624_b(target);
                target.func_184205_a((Entity)entity, true);
                EntityUtil.playSound((Entity)entity, (SoundEvent)SoundRegister.DRAG.get());
                if (--cnt > 0) continue;
                break;
            }
        }
    }

    @Override
    public boolean canPlantTarget(Entity entity) {
        return super.canPlantTarget(entity) && (entity.func_184187_bx() == null || entity.func_184187_bx().func_70028_i((Entity)this));
    }

    public float getAttackDamage() {
        return PlantUtil.getPlantAverageProgress((PVZPlantEntity)this, 150, 350);
    }

    public int getSuperCount() {
        return this.isPlantInStage(1) ? 3 : (this.isPlantInStage(2) ? 4 : 5);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return new EntitySize(0.6f, 1.0f, false);
    }

    public double func_70042_X() {
        return 0.0;
    }

    public boolean func_205710_ba() {
        return true;
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return true;
    }

    public boolean func_189652_ae() {
        return this.func_70090_H();
    }

    @Override
    public int getSuperTimeLength() {
        return 20;
    }

    @Override
    protected boolean canBeImmuneToEnforce(Entity entity) {
        return true;
    }

    @Override
    public int getAttackCD() {
        return 20;
    }

    @Override
    public float getCloseHeight() {
        return 2.0f;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.TANGLE_KELP;
    }
}

