/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.explosion;

import com.hungteen.pvz.common.entity.bullet.itembullet.FireCrackerEntity;
import com.hungteen.pvz.common.entity.misc.FireCrackersEntity;
import com.hungteen.pvz.common.entity.plant.base.PlantCloserEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.MathUtil;
import com.hungteen.pvz.utils.WorldUtil;
import com.hungteen.pvz.utils.enums.Plants;
import java.util.ArrayList;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BambooLordEntity
extends PlantCloserEntity {
    public static final int UP_CD = 20;
    public static final float UP_SPEED = 2.0f;

    public BambooLordEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public void focusOnTarget(LivingEntity target1) {
        super.focusOnTarget(target1);
        if (this.getAttackTime() == 1) {
            float range = 2.0f;
            EntityUtil.getTargetableEntities((Entity)this, EntityUtil.getEntityAABB((Entity)this, 2.0, 2.0)).forEach(target -> target.func_213317_d(target.func_213322_ci().func_72441_c(0.0, 2.0, 0.0)));
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 2.0, 0.0));
            for (int i = 0; i < 3; ++i) {
                EntityUtil.spawnParticle((Entity)this, 5);
            }
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.POTATO_MINE.get());
        }
    }

    @Override
    public void performAttack(LivingEntity target1) {
        for (int i = 0; i < 3; ++i) {
            EntityUtil.spawnParticle((Entity)this, 5);
        }
        float range = 3.0f;
        EntityUtil.getTargetableEntities((Entity)this, EntityUtil.getEntityAABB((Entity)this, 3.0, 3.0)).forEach(target -> {
            target.func_70097_a((DamageSource)PVZDamageSource.explode((Entity)this), this.getAttackDamage());
            target.func_213317_d(target.func_213322_ci().func_72441_c(0.0, 2.0, 0.0));
        });
        this.split();
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.POTATO_MINE.get());
    }

    protected void split() {
        int i;
        float range = 30.0f;
        ArrayList list = new ArrayList();
        EntityUtil.getTargetableLivings((Entity)this, EntityUtil.getEntityAABB((Entity)this, 30.0, 30.0)).forEach(target -> {
            if (this.func_70635_at().func_75522_a((Entity)target)) {
                list.add(target);
            }
        });
        if (!list.isEmpty()) {
            for (i = 0; i < this.getSplitCount(); ++i) {
                int pos = this.func_70681_au().nextInt(list.size());
                FireCrackerEntity entity = new FireCrackerEntity(this.field_70170_p, (LivingEntity)this);
                entity.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                entity.shoot((Entity)list.get(pos));
                entity.summonByOwner((Entity)this);
                entity.setAttackDamage(this.getAttackDamage() * 2.0f);
                this.field_70170_p.func_217376_c((Entity)entity);
            }
        }
        for (i = 0; i < 3; ++i) {
            EntityUtil.spawnParticle((Entity)this, 5);
        }
        this.func_70106_y();
    }

    @Override
    public void startSuperMode(boolean first) {
        super.startSuperMode(first);
        for (int i = 0; i < this.getCrackersNum(); ++i) {
            this.generateCracker();
        }
    }

    protected void generateCracker() {
        int range = 10;
        BlockPos pos = WorldUtil.getSuitableHeightRandomPos(this.field_70170_p, this.func_233580_cy_(), 10);
        FireCrackersEntity entity = new FireCrackersEntity(this.field_70170_p, (LivingEntity)this);
        entity.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        entity.setFuse(10);
        entity.summonByOwner((Entity)this);
        this.field_70170_p.func_217376_c((Entity)entity);
    }

    public float getAttackDamage() {
        return this.getAverageProgress(60.0f, 160.0f);
    }

    public int getSplitCount() {
        return MathUtil.getProgressByDif(5, 1, this.getPlantLvl(), 20, 2, 5);
    }

    public int getCrackersNum() {
        return this.getThreeStage(10, 15, 20);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.6f, (float)1.0f);
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.BAMBOO_LORD;
    }
}

