/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.explosion;

import com.hungteen.pvz.common.advancement.trigger.EntityEffectAmountTrigger;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.entity.plant.base.PlantBomberEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.ParticleRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.MathUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class CherryBombEntity
extends PlantBomberEntity {
    public CherryBombEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public void startBomb(boolean server) {
        if (server) {
            int deathCnt = 0;
            float range = 4.5f;
            AxisAlignedBB aabb = EntityUtil.getEntityAABB((Entity)this, 4.5, 4.5);
            for (Entity target : EntityUtil.getWholeTargetableEntities((Entity)this, aabb)) {
                target.func_70097_a((DamageSource)PVZDamageSource.explode((Entity)this), this.getAttackDamage());
                if (EntityUtil.isEntityValid(target)) continue;
                ++deathCnt;
            }
            PVZPlantEntity.clearLadders((LivingEntity)this, aabb);
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.CHERRY_BOMB.get());
            PlayerEntity owner = EntityUtil.getEntityOwner(this.field_70170_p, (Entity)this);
            if (owner != null && owner instanceof ServerPlayerEntity) {
                EntityEffectAmountTrigger.INSTANCE.trigger((ServerPlayerEntity)owner, (Entity)this, deathCnt);
            }
        } else {
            for (int i = 0; i < 5; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleRegister.RED_BOMB.get(), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        }
    }

    public float getAttackDamage() {
        return MathUtil.getProgressAverage(this.getPlantLvl(), 20, 150, 650);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return new EntitySize(0.9f, 1.0f, false);
    }

    @Override
    public int getReadyTime() {
        return 30;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.CHERRY_BOMB;
    }
}

