/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.explosion;

import com.hungteen.pvz.common.entity.misc.DoomFixerEntity;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.entity.plant.base.PlantBomberEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.ParticleRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.WorldUtil;
import com.hungteen.pvz.utils.enums.Plants;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class DoomShroomEntity
extends PlantBomberEntity {
    public static final float MAX_EXPLOSION_LEVEL = 500.0f;

    public DoomShroomEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K && this.getAttackTime() == this.getReadyTime() - 2) {
            DoomFixerEntity fixer = new DoomFixerEntity(this.field_70170_p, this);
            EntityUtil.onEntitySpawn((IWorld)this.field_70170_p, fixer, this.func_233580_cy_());
        }
    }

    @Override
    public void startBomb(boolean server) {
        if (server) {
            float range = 10.5f;
            AxisAlignedBB aabb = EntityUtil.getEntityAABB((Entity)this, 10.5, 10.5);
            EntityUtil.getWholeTargetableEntities((Entity)this, aabb).forEach(target -> {
                if (target instanceof EnderDragonEntity) {
                    ((EnderDragonEntity)target).func_70097_a(((EntityDamageSource)DamageSource.func_76358_a((LivingEntity)this)).func_180138_v().func_94540_d(), this.getAttackDamage() * 2.0f);
                } else {
                    target.func_70097_a((DamageSource)PVZDamageSource.explode((Entity)this), this.getAttackDamage());
                }
            });
            PVZPlantEntity.clearLadders((LivingEntity)this, aabb);
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.DOOM.get());
            if (ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
                this.destroyBlocks();
            }
        } else {
            for (int i = 0; i < 300; ++i) {
                WorldUtil.spawnRandomSpeedParticle(this.field_70170_p, (IParticleData)ParticleRegister.SPORE.get(), this.func_213303_ch().func_72441_c(0.0, 1.0, 0.0), 0.8f);
            }
        }
    }

    protected void destroyBlocks() {
        ObjectArrayList list = new ObjectArrayList();
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        int len = 2;
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                for (int k = -2; k < 0; ++k) {
                    posList.add(this.func_233580_cy_().func_177982_a(i, k, j));
                }
            }
        }
        int range = 10;
        for (int h = 0; h <= 18; ++h) {
            for (int i = -10; i <= 10; ++i) {
                for (int j = -10; j <= 10; ++j) {
                    Vector3d vector3d = new Vector3d((double)i, (double)(h - 5), (double)j);
                    if (!(vector3d.func_189985_c() <= 100.0)) continue;
                    posList.add(this.func_233580_cy_().func_177982_a(i, h, j));
                }
            }
        }
        posList.forEach(pos -> {
            BlockState state = this.field_70170_p.func_180495_p(pos);
            if (state.isAir((IBlockReader)this.field_70170_p, pos) || state.func_177230_c().func_149638_a() > 500.0f) {
                return;
            }
            TileEntity tileentity = state.hasTileEntity() ? this.field_70170_p.func_175625_s(pos) : null;
            LootContext.Builder loot = new LootContext.Builder((ServerWorld)this.field_70170_p).func_216023_a(this.field_70170_p.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)pos)).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216021_b(LootParameters.field_216288_h, (Object)tileentity).func_216021_b(LootParameters.field_216281_a, (Object)this);
            loot.func_216015_a(LootParameters.field_216290_j, (Object)Float.valueOf(2.0f));
            state.func_215693_a(loot).forEach(stack -> {
                for (int l = 0; l < list.size(); ++l) {
                    Pair pair = (Pair)list.get(l);
                    ItemStack itemstack = (ItemStack)pair.getFirst();
                    if (!ItemEntity.func_226532_a_((ItemStack)itemstack, (ItemStack)stack)) continue;
                    ItemStack itemstack1 = ItemEntity.func_226533_a_((ItemStack)itemstack, (ItemStack)stack, (int)16);
                    list.set(l, (Object)Pair.of((Object)itemstack1, (Object)pair.getSecond()));
                    if (!list.isEmpty()) continue;
                    return;
                }
                list.add((Object)Pair.of((Object)stack, (Object)pos));
            });
            this.field_70170_p.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        });
        for (Pair pair : list) {
            Block.func_180635_a((World)this.field_70170_p, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
        }
    }

    public float getAttackDamage() {
        return PlantUtil.getPlantAverageProgress((PVZPlantEntity)this, 200, 800);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.8f, (float)1.5f);
    }

    @Override
    public int getReadyTime() {
        return 50;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.DOOM_SHROOM;
    }
}

