/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.explosion;

import com.hungteen.pvz.common.entity.bullet.itembullet.PotatoEntity;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.entity.plant.base.PlantCloserEntity;
import com.hungteen.pvz.common.entity.zombie.poolnight.DiggerZombieEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.ParticleRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.MathUtil;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.WorldUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class PotatoMineEntity
extends PlantCloserEntity {
    public static final int RISING_ANIM_CD = 20;
    public static final int PREPARE_CD = 240;

    public PotatoMineEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K) {
            if (this.getExistTick() == 221) {
                EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.DIRT_RISE.get());
            }
        } else if (this.isRisingFromDirt()) {
            for (int i = 0; i < 1; ++i) {
                Vector3d offset = new Vector3d((double)MathUtil.getRandomFloat(this.func_70681_au()), 0.0, (double)MathUtil.getRandomFloat(this.func_70681_au())).func_72432_b();
                WorldUtil.spawnRandomSpeedParticle(this.field_70170_p, (IParticleData)ParticleRegister.DIRT_BURST_OUT.get(), this.func_213303_ch().func_178787_e(offset), MathUtil.getRandomFloat(this.func_70681_au()) / 8.0f, 0.06f);
            }
        }
    }

    @Override
    public void performAttack(LivingEntity target1) {
        if (!this.field_70170_p.field_72995_K) {
            float range = 1.6f;
            AxisAlignedBB aabb = EntityUtil.getEntityAABB((Entity)this, 1.6f, 1.6f);
            EntityUtil.getWholeTargetableEntities((Entity)this, aabb).forEach(target -> target.func_70097_a((DamageSource)PVZDamageSource.explode((Entity)this), this.getAttackDamage()));
            PVZPlantEntity.clearLadders((LivingEntity)this, aabb);
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.POTATO_MINE.get());
            for (int i = 1; i <= 10; ++i) {
                EntityUtil.spawnParticle((Entity)this, 3);
                EntityUtil.spawnParticle((Entity)this, 4);
            }
            this.func_70106_y();
        }
    }

    @Override
    public boolean canPlantTarget(Entity target) {
        if (target instanceof DiggerZombieEntity) {
            return true;
        }
        return super.canPlantTarget(target);
    }

    @Override
    public boolean canStartSuperMode() {
        return super.canStartSuperMode() && this.getAttackTime() <= 0;
    }

    @Override
    public void startSuperMode(boolean first) {
        super.startSuperMode(first);
        this.shootPotatos();
        if (!this.isRisingFromDirt() && !this.isMineReady()) {
            this.setRisingFromDirt();
        }
    }

    protected void shootPotatos() {
        int num = this.getShootNum();
        for (int i = 1; i <= num; ++i) {
            PotatoEntity potato = new PotatoEntity(this.field_70170_p, (LivingEntity)this);
            potato.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_());
            float dx = MathUtil.getRandomFloat(this.func_70681_au()) * (float)i / 2.0f;
            float dy = 0.5f;
            float dz = MathUtil.getRandomFloat(this.func_70681_au()) * (float)i / 2.0f;
            potato.shoot(dx, 0.5, dz);
            potato.summonByOwner((Entity)this);
            this.field_70170_p.func_217376_c((Entity)potato);
        }
    }

    public int getShootNum() {
        return this.isPlantInStage(1) ? 3 : (this.isPlantInStage(2) ? 4 : 5);
    }

    public boolean isMineReady() {
        return this.getExistTick() > 240;
    }

    public boolean isRisingFromDirt() {
        return this.getExistTick() >= 220 && this.getExistTick() <= 240;
    }

    public void setRisingFromDirt() {
        this.setExistTick(218);
    }

    @Override
    protected boolean canBeImmuneToEnforce(Entity entity) {
        return super.canBeImmuneToEnforce(entity) && (this.isMineReady() || this.isRisingFromDirt());
    }

    @Override
    public boolean canCheckDistance() {
        return this.isMineReady();
    }

    public float getAttackDamage() {
        return PlantUtil.getPlantAverageProgress((PVZPlantEntity)this, 125, 425);
    }

    public int getSignChangeCD() {
        return this.isMineReady() ? 10 : 20;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return new EntitySize(0.6f, 0.4f, false);
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.POTATO_MINE;
    }
}

