/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.flame;

import com.hungteen.pvz.common.entity.misc.ElementBallEntity;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.entity.plant.base.PlantBomberEntity;
import com.hungteen.pvz.common.entity.zombie.zombotany.JalapenoZombieEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.WorldUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class JalapenoEntity
extends PlantBomberEntity {
    public JalapenoEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public void startBomb(boolean server) {
        int range = 20;
        if (server) {
            JalapenoEntity.fireMob((LivingEntity)this, 20.0f, 1.0f);
            JalapenoEntity.fireMob((LivingEntity)this, 1.0f, 20.0f);
            ElementBallEntity.killElementBalls((LivingEntity)this, 40.0f, ElementBallEntity.ElementTypes.ICE);
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.JALAPENO.get());
        }
        JalapenoEntity.clearSnowAndSpawnFlame((LivingEntity)this, 20);
    }

    public static void fireMob(LivingEntity entity, float dx, float dz) {
        AxisAlignedBB aabb = new AxisAlignedBB(entity.func_213303_ch().func_72441_c((double)dx, 1.0, (double)dz), entity.func_213303_ch().func_72441_c((double)(-dx), -1.0, (double)(-dz)));
        for (Entity target : EntityUtil.getWholeTargetableEntities((Entity)entity, aabb)) {
            float damage = 0.0f;
            if (entity instanceof JalapenoEntity) {
                damage = ((JalapenoEntity)entity).getAttackDamage();
            } else if (entity instanceof JalapenoZombieEntity) {
                damage = target instanceof LivingEntity ? EntityUtil.getMaxHealthDamage((LivingEntity)target, 2.0f) : 100.0f;
            }
            target.func_70097_a(PVZDamageSource.causeFlameDamage((Entity)entity, (Entity)entity).func_94540_d(), damage);
        }
        PVZPlantEntity.clearLadders(entity, aabb);
    }

    public static void clearSnowAndSpawnFlame(LivingEntity entity, int range) {
        int i;
        boolean flag = ForgeEventFactory.getMobGriefingEvent((World)entity.field_70170_p, (Entity)entity);
        for (i = -range; i <= range; ++i) {
            JalapenoEntity.spawnFlame(entity, i, 0);
            JalapenoEntity.spawnFlame(entity, 0, i);
            if (!flag) continue;
            JalapenoEntity.clearSnow(entity, i, 0);
            JalapenoEntity.clearSnow(entity, 0, i);
        }
        if (flag) {
            for (i = -range / 2; i <= range / 2; ++i) {
                for (int j = -range / 2; j <= range / 2; ++j) {
                    JalapenoEntity.clearSnow(entity, i, j);
                }
            }
        }
    }

    private static void spawnFlame(LivingEntity entity, int dx, int dz) {
        if (entity.field_70170_p.field_72995_K) {
            for (int i = 0; i < 20; ++i) {
                WorldUtil.spawnRandomSpeedParticle(entity.field_70170_p, (IParticleData)ParticleTypes.field_197631_x, entity.func_213303_ch().func_72441_c((double)dx, 0.0, (double)dz), 0.1f);
            }
        }
    }

    private static void clearSnow(LivingEntity entity, int dx, int dz) {
        BlockPos pos;
        if (!(entity.field_70170_p.field_72995_K || entity.field_70170_p.func_180495_p(pos = entity.func_233580_cy_().func_177982_a(dx, 0, dz)).func_177230_c() != Blocks.field_150433_aE && entity.field_70170_p.func_180495_p(pos).func_177230_c() != Blocks.field_196604_cC)) {
            entity.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    public float getAttackDamage() {
        return PlantUtil.getPlantAverageProgress((PVZPlantEntity)this, 150, 450);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.7f, (float)1.5f);
    }

    @Override
    public int getReadyTime() {
        return 30;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.JALAPENO;
    }
}

