/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.flame;

import com.hungteen.pvz.api.interfaces.ILightEffect;
import com.hungteen.pvz.common.entity.bullet.itembullet.PeaEntity;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.register.EffectRegister;
import com.hungteen.pvz.register.ParticleRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.WorldUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.world.World;

public class TorchWoodEntity
extends PVZPlantEntity
implements ILightEffect {
    private static final DataParameter<Integer> FLAME_TYPE = EntityDataManager.func_187226_a(TorchWoodEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public TorchWoodEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLAME_TYPE, (Object)FlameTypes.YELLOW.ordinal());
    }

    @Override
    protected void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa % 40 == 0) {
                this.giveLightToPlayers(10.0f);
            }
            this.heatPeas();
        } else {
            IParticleData particle = (IParticleData)ParticleRegister.YELLOW_FLAME.get();
            if (this.getFlameType() == FlameTypes.BLUE) {
                particle = (IParticleData)ParticleRegister.BLUE_FLAME.get();
            }
            WorldUtil.spawnRandomSpeedParticle(this.field_70170_p, particle, this.func_213303_ch().func_72441_c(0.0, 1.5, 0.0), 0.1f);
        }
    }

    public void heatPeas() {
        float range = this.getHeatRange();
        this.field_70170_p.func_217357_a(PeaEntity.class, EntityUtil.getEntityAABB((Entity)this, range, range)).forEach(pea -> pea.heatBy(this));
    }

    private void giveLightToPlayers(float range) {
        this.field_70170_p.func_175647_a(PlayerEntity.class, EntityUtil.getEntityAABB((Entity)this, range, range), player -> !EntityUtil.canTargetEntity((Entity)this, (Entity)player)).forEach(player -> player.func_195064_c(this.getLightEyeEffect()));
    }

    @Override
    public EffectInstance getLightEyeEffect() {
        return new EffectInstance((Effect)EffectRegister.LIGHT_EYE_EFFECT.get(), 100, 0, false, false);
    }

    @Override
    public void startSuperMode(boolean first) {
        super.startSuperMode(first);
        this.setFlameType(FlameTypes.BLUE);
    }

    @Override
    public boolean canStartSuperMode() {
        return super.canStartSuperMode() && this.getFlameType() == FlameTypes.YELLOW;
    }

    public float getHeatRange() {
        return this.isPlantInStage(1) ? 1.5f : (this.isPlantInStage(2) ? 2.0f : 2.5f);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return new EntitySize(0.95f, 1.95f, false);
    }

    @Override
    public int getSuperTimeLength() {
        return 20;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("flame_type")) {
            this.setFlameType(FlameTypes.values()[compound.func_74762_e("flame_type")]);
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("flame_type", this.getFlameType().ordinal());
    }

    public FlameTypes getFlameType() {
        return FlameTypes.values()[(Integer)this.field_70180_af.func_187225_a(FLAME_TYPE)];
    }

    public void setFlameType(FlameTypes type) {
        this.field_70180_af.func_187227_b(FLAME_TYPE, (Object)type.ordinal());
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.TORCH_WOOD;
    }

    public static enum FlameTypes {
        YELLOW,
        BLUE,
        PURPLE;

    }
}

