/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.ice;

import com.hungteen.pvz.api.interfaces.IIceEffect;
import com.hungteen.pvz.common.advancement.trigger.EntityEffectAmountTrigger;
import com.hungteen.pvz.common.entity.misc.ElementBallEntity;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.entity.plant.base.PlantBomberEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.EffectRegister;
import com.hungteen.pvz.register.ParticleRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.MathUtil;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.enums.Plants;
import java.util.Optional;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class IceShroomEntity
extends PlantBomberEntity
implements IIceEffect {
    public IceShroomEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public void startBomb(boolean server) {
        if (server) {
            float len = 20.0f;
            AxisAlignedBB aabb = EntityUtil.getEntityAABB((Entity)this, 20.0, 20.0);
            int cnt = 0;
            for (LivingEntity entity : EntityUtil.getTargetableLivings((Entity)this, aabb)) {
                PVZDamageSource source = PVZDamageSource.causeIceDamage((Entity)this, (Entity)this);
                this.getColdEffect().ifPresent(e -> source.addEffect((EffectInstance)e));
                this.getFrozenEffect().ifPresent(e -> source.addEffect((EffectInstance)e));
                entity.func_70097_a((DamageSource)source, this.getAttackDamage());
                if (!EntityUtil.isEntityCold(entity)) continue;
                ++cnt;
            }
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.FROZEN_HIT.get());
            PlayerEntity player = EntityUtil.getEntityOwner(this.field_70170_p, (Entity)this);
            if (player != null && player instanceof ServerPlayerEntity) {
                EntityEffectAmountTrigger.INSTANCE.trigger((ServerPlayerEntity)player, (Entity)this, cnt);
            }
            ElementBallEntity.killElementBalls((LivingEntity)this, 40.0f, ElementBallEntity.ElementTypes.FLAME);
        } else {
            int i;
            for (i = 0; i < 3; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
            for (i = 0; i < 15; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleRegister.SNOW_FLOWER.get(), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (double)((this.func_70681_au().nextFloat() - 0.5f) / 4.0f), (double)(this.func_70681_au().nextFloat() / 5.0f), (double)((this.func_70681_au().nextFloat() - 0.5f) / 4.0f));
            }
        }
    }

    @Override
    public int getReadyTime() {
        return 30;
    }

    public float getAttackDamage() {
        int lvl = this.getPlantLvl();
        return lvl <= 20 ? 0.1f * (float)lvl : 10.0f;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.85f, (float)1.35f);
    }

    public int getColdLvl() {
        return MathUtil.getProgressByDif(4, 1, this.getPlantLvl(), 20, 3, 7);
    }

    public int getColdTick() {
        return PlantUtil.getPlantAverageProgress((PVZPlantEntity)this, 0, 200);
    }

    public int getFrozenTick() {
        return PlantUtil.getPlantAverageProgress((PVZPlantEntity)this, 100, 240);
    }

    @Override
    public Optional<EffectInstance> getColdEffect() {
        return Optional.ofNullable(new EffectInstance((Effect)EffectRegister.COLD_EFFECT.get(), this.getColdTick() + this.getFrozenTick(), this.getColdLvl(), false, false));
    }

    @Override
    public Optional<EffectInstance> getFrozenEffect() {
        return Optional.ofNullable(new EffectInstance((Effect)EffectRegister.FROZEN_EFFECT.get(), this.getFrozenTick(), 1, false, false));
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.ICE_SHROOM;
    }
}

