/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.ice;

import com.hungteen.pvz.api.interfaces.IIceEffect;
import com.hungteen.pvz.common.advancement.trigger.EntityEffectAmountTrigger;
import com.hungteen.pvz.common.entity.plant.base.PlantCloserEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.EffectRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.MathUtil;
import com.hungteen.pvz.utils.enums.Plants;
import java.util.Optional;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class IcebergLettuceEntity
extends PlantCloserEntity
implements IIceEffect {
    private static final int FROZEN_TICK = 200;

    public IcebergLettuceEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public void performAttack(LivingEntity target) {
        for (int i = 0; i < 2; ++i) {
            EntityUtil.spawnParticle((Entity)this, 5);
        }
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.FROZEN_HIT.get());
        this.dealDamageTo((Entity)target);
        this.func_70106_y();
    }

    @Override
    public void startSuperMode(boolean first) {
        super.startSuperMode(first);
        float range = this.getSuperRange();
        for (int i = 0; i < 2; ++i) {
            EntityUtil.spawnParticle((Entity)this, 5);
        }
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.FROZEN_HIT.get());
        int cnt = 0;
        for (Entity target : EntityUtil.getTargetableEntities((Entity)this, EntityUtil.getEntityAABB((Entity)this, range, range))) {
            this.dealDamageTo(target);
            if (!(target instanceof LivingEntity) || !EntityUtil.isEntityCold((LivingEntity)target)) continue;
            ++cnt;
        }
        PlayerEntity player = EntityUtil.getEntityOwner(this.field_70170_p, (Entity)this);
        if (player != null && player instanceof ServerPlayerEntity) {
            EntityEffectAmountTrigger.INSTANCE.trigger((ServerPlayerEntity)player, (Entity)this, cnt);
        }
    }

    private void dealDamageTo(Entity target) {
        PVZDamageSource source = PVZDamageSource.causeIceDamage((Entity)this, (Entity)this);
        this.getColdEffect().ifPresent(e -> source.addEffect((EffectInstance)e));
        this.getFrozenEffect().ifPresent(e -> source.addEffect((EffectInstance)e));
        target.func_70097_a((DamageSource)source, 0.001f);
    }

    @Override
    public Optional<EffectInstance> getColdEffect() {
        return Optional.ofNullable(new EffectInstance((Effect)EffectRegister.COLD_EFFECT.get(), 200 + this.getColdDuration(), this.getColdLevel(), false, false));
    }

    @Override
    public Optional<EffectInstance> getFrozenEffect() {
        return Optional.ofNullable(new EffectInstance((Effect)EffectRegister.FROZEN_EFFECT.get(), 200, 1, false, false));
    }

    public int getColdLevel() {
        return MathUtil.getProgressByDif(5, 1, this.getPlantLvl(), 20, 4, 7);
    }

    public int getColdDuration() {
        return this.getAverageProgress(100, 300);
    }

    public float getSuperRange() {
        return this.getThreeStage(20, 25, 30);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220311_c((float)0.6f, (float)0.6f);
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.ICEBERG_LETTUCE;
    }
}

