/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.ice;

import com.hungteen.pvz.api.interfaces.IIceEffect;
import com.hungteen.pvz.common.entity.bullet.itembullet.PeaEntity;
import com.hungteen.pvz.common.entity.plant.appease.PeaShooterEntity;
import com.hungteen.pvz.register.EffectRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.MathUtil;
import com.hungteen.pvz.utils.enums.Plants;
import java.util.Optional;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class SnowPeaEntity
extends PeaShooterEntity
implements IIceEffect {
    public SnowPeaEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public Optional<EffectInstance> getColdEffect() {
        return Optional.ofNullable(new EffectInstance((Effect)EffectRegister.COLD_EFFECT.get(), this.getColdTick(), this.getColdLvl(), false, false));
    }

    @Override
    public Optional<EffectInstance> getFrozenEffect() {
        return Optional.empty();
    }

    public int getColdLvl() {
        return MathUtil.getProgressByDif(4, 1, this.getPlantLvl(), 20, 5, 9);
    }

    public int getColdTick() {
        return MathUtil.getProgressAverage(this.getPlantLvl(), 20, 80, 160);
    }

    @Override
    protected SoundEvent getShootSound() {
        return (SoundEvent)SoundRegister.SNOW_SHOOT.get();
    }

    @Override
    protected PeaEntity.State getShootState() {
        return PeaEntity.State.ICE;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.SNOW_PEA;
    }
}

