/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.ice;

import com.hungteen.pvz.api.interfaces.IIceEffect;
import com.hungteen.pvz.common.entity.bullet.MelonEntity;
import com.hungteen.pvz.common.entity.plant.arma.MelonPultEntity;
import com.hungteen.pvz.register.EffectRegister;
import com.hungteen.pvz.utils.enums.Plants;
import java.util.Optional;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.world.World;

public class WinterMelonEntity
extends MelonPultEntity
implements IIceEffect {
    public WinterMelonEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public int getColdLvl() {
        return this.getAverageProgress(7, 11);
    }

    public int getColdTick() {
        return this.getAverageProgress(80, 160);
    }

    @Override
    public Optional<EffectInstance> getColdEffect() {
        return Optional.ofNullable(new EffectInstance((Effect)EffectRegister.COLD_EFFECT.get(), this.getColdTick(), this.getColdLvl(), false, false));
    }

    @Override
    public Optional<EffectInstance> getFrozenEffect() {
        return Optional.empty();
    }

    @Override
    protected MelonEntity.MelonStates getThrowMelonState() {
        return MelonEntity.MelonStates.ICE;
    }

    @Override
    public Plants getUpgradePlantType() {
        return null;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.WINTER_MELON;
    }
}

