/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.light;

import com.hungteen.pvz.common.block.special.GoldTileBlock;
import com.hungteen.pvz.common.entity.plant.base.PlantBomberEntity;
import com.hungteen.pvz.register.BlockRegister;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.world.World;

public class GoldLeafEntity
extends PlantBomberEntity {
    public static final int GOLD_GEN_CD = 400;

    public GoldLeafEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
        this.canCollideWithPlant = false;
    }

    @Override
    public void startBomb(boolean server) {
        Block block = this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177977_b()).func_177230_c();
        int lvl = GoldLeafEntity.getBlockGoldLevel(block);
        if (server && lvl >= 0 && lvl < this.getTileLevel()) {
            this.field_70170_p.func_175656_a(this.func_233580_cy_().func_177977_b(), GoldLeafEntity.getGoldTileByLvl(this.getTileLevel()).func_176223_P());
        }
    }

    public static int getBlockGoldLevel(Block block) {
        if (block instanceof GoldTileBlock) {
            return ((GoldTileBlock)block).lvl;
        }
        if (block == Blocks.field_150340_R) {
            return 0;
        }
        return -1;
    }

    public static int getGoldGenAmount(int lvl) {
        return lvl == 1 ? 25 : (lvl == 2 ? 50 : 75);
    }

    public static Block getGoldTileByLvl(int lvl) {
        return lvl == 1 ? (Block)BlockRegister.GOLD_TILE1.get() : (lvl == 2 ? (Block)BlockRegister.GOLD_TILE2.get() : (Block)BlockRegister.GOLD_TILE3.get());
    }

    public int getTileLevel() {
        return this.getThreeStage(1, 2, 3);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.6f, (float)1.0f);
    }

    @Override
    public int getReadyTime() {
        return 60;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.GOLD_LEAF;
    }
}

