/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.light;

import com.hungteen.pvz.api.interfaces.ILightEffect;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.register.EffectRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class PlanternEntity
extends PVZPlantEntity
implements ILightEffect {
    private static final int EFFECT_CD = 50;

    public PlanternEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K && this.getExistTick() % 50 == 0) {
            this.giveLightToPlayers();
        }
    }

    private void giveLightToPlayers() {
        float range = 30.0f;
        EntityUtil.getFriendlyLivings((Entity)this, EntityUtil.getEntityAABB((Entity)this, 30.0, 30.0)).stream().filter(e -> e instanceof PlayerEntity).forEach(entity -> entity.func_195064_c(this.getLightEyeEffect()));
    }

    @Override
    public void startSuperMode(boolean first) {
        super.startSuperMode(first);
        float range = 30.0f;
        EntityUtil.getFriendlyLivings((Entity)this, EntityUtil.getEntityAABB((Entity)this, 30.0, 30.0)).forEach(entity -> entity.func_195064_c(this.createEffect(1, this.getSuperLightEyeTime())));
        EntityUtil.playSound((Entity)this, this.getSpawnSound());
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.75f, (float)1.7f);
    }

    @Override
    public int getSuperTimeLength() {
        return 20;
    }

    @Override
    public EffectInstance getLightEyeEffect() {
        return this.createEffect(0, this.getLightEyeTime());
    }

    private EffectInstance createEffect(int lvl, int time) {
        return new EffectInstance((Effect)EffectRegister.LIGHT_EYE_EFFECT.get(), time, lvl, false, false);
    }

    public int getLightEyeTime() {
        return Math.min(4000, this.getPlantLvl() * 200);
    }

    public int getSuperLightEyeTime() {
        return this.isPlantInStage(1) ? 3600 : (this.isPlantInStage(2) ? 7200 : 10800);
    }

    @Override
    protected SoundEvent getSpawnSound() {
        return (SoundEvent)SoundRegister.PLANTERN.get();
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.PLANTERN;
    }
}

