/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.light;

import com.hungteen.pvz.common.entity.drop.SunEntity;
import com.hungteen.pvz.common.entity.plant.base.PlantProducerEntity;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.MathUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;

public class SunFlowerEntity
extends PlantProducerEntity {
    public SunFlowerEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public void genSomething() {
        this.genSun(this.getSunAmount());
    }

    @Override
    public void genSuper() {
        SunEntity.spawnSunsByAmount(this.field_70170_p, this.func_233580_cy_(), this.getSuperSunAmount(), 100, 3);
        EntityUtil.playSound((Entity)this, SoundEvents.field_187604_bf);
    }

    public int getSunAmount() {
        return MathUtil.getProgressByDif(4, 5, this.getPlantLvl(), 20, 25, 50);
    }

    public int getSuperSunAmount() {
        return this.getThreeStage(500, 750, 1000);
    }

    @Override
    public int getGenCD() {
        int time = 500;
        return this.field_70170_p.func_72935_r() && !this.field_70170_p.func_72896_J() ? 500 : 2000;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.8f, (float)1.65f);
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.SUN_FLOWER;
    }

    @Override
    public Plants getUpgradePlantType() {
        return Plants.TWIN_SUNFLOWER;
    }
}

