/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.magic;

import com.hungteen.pvz.api.interfaces.ICanBeAttracted;
import com.hungteen.pvz.common.entity.ai.goal.misc.PlantAttractGoal;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.common.entity.zombie.roof.GargantuarEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.enums.Plants;
import com.hungteen.pvz.utils.interfaces.ICanAttract;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class HypnoShroomEntity
extends PVZPlantEntity
implements ICanAttract {
    public HypnoShroomEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new PlantAttractGoal(this, this, 25));
    }

    @Override
    public boolean canAttract(LivingEntity target) {
        if (target instanceof ICanBeAttracted && !((ICanBeAttracted)target).canBeAttractedBy(this)) {
            return false;
        }
        if (!this.func_70635_at().func_75522_a((Entity)target)) {
            return false;
        }
        if (target instanceof MobEntity) {
            return !(((MobEntity)target).func_70638_az() instanceof HypnoShroomEntity);
        }
        return false;
    }

    @Override
    public void attract(LivingEntity target) {
        if (target instanceof MobEntity) {
            ((MobEntity)target).func_70624_b((LivingEntity)this);
        }
    }

    @Override
    public float getAttractRange() {
        return 2.5f;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && !this.canPlantNormalUpdate() && cause instanceof PVZDamageSource && ((PVZDamageSource)cause).isEatDamage()) {
            PVZZombieEntity zombie;
            if (this.isPlantInSuperMode()) {
                if (cause.func_76346_g() != null) {
                    cause.func_76346_g().func_70106_y();
                    GargantuarEntity gar = (GargantuarEntity)((EntityType)EntityRegister.GARGANTUAR.get()).func_200721_a(this.field_70170_p);
                    EntityUtil.onEntitySpawn((IWorld)this.field_70170_p, (Entity)gar, cause.func_76346_g().func_233580_cy_());
                    this.perfromCharmTo(gar);
                    gar.setZombieType(PVZZombieEntity.Type.NORMAL);
                    gar.func_70606_j(gar.func_110138_aP() * this.getSummonHealth());
                    gar.setCharmed(!this.isCharmed());
                }
            } else if (cause.func_76346_g() instanceof PVZZombieEntity && (zombie = (PVZZombieEntity)cause.func_76346_g()).getZombieLevel() <= this.getPlantLvl()) {
                zombie.onCharmedBy((LivingEntity)this);
                zombie.healZombie(EntityUtil.getCurrentMaxHealth((LivingEntity)zombie) * this.getHealHealth());
                this.perfromCharmTo(zombie);
            }
        }
    }

    protected void perfromCharmTo(PVZZombieEntity zombie) {
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.CHARM.get());
        zombie.updateZombieLevel(Math.min(20, this.getPlantLvl()));
    }

    @Override
    public float getPlantHealth() {
        return 30.0f;
    }

    public float getHealHealth() {
        return PlantUtil.getPlantAverageProgress((PVZPlantEntity)this, 0.2f, 1.0f);
    }

    public float getSummonHealth() {
        return this.isPlantInStage(1) ? 0.5f : (this.isPlantInStage(2) ? 0.75f : 1.0f);
    }

    @Override
    public boolean isPlantImmuneTo(DamageSource source) {
        return false;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.7f, (float)1.9f);
    }

    @Override
    public int getSuperTimeLength() {
        return 2400;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.HYPNO_SHROOM;
    }
}

