/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.magic;

import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.entity.plant.base.PlantBomberEntity;
import com.hungteen.pvz.common.item.card.BlockPlantCardItem;
import com.hungteen.pvz.common.item.card.ImitaterCardItem;
import com.hungteen.pvz.common.item.card.PlantCardItem;
import com.hungteen.pvz.register.BlockRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.enums.Plants;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ImitaterEntity
extends PlantBomberEntity {
    private static final DataParameter<ItemStack> IMITATE_CARD = EntityDataManager.func_187226_a(ImitaterEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    public Optional<PVZPlantEntity> targetPlantEntity = Optional.empty();
    public Optional<BlockPos> targetPos = Optional.empty();
    public Direction placeDirection = Direction.NORTH;

    public ImitaterEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
        this.canCollideWithPlant = false;
        this.isImmuneToWeak = true;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IMITATE_CARD, (Object)ItemStack.field_190927_a);
    }

    @Override
    protected void func_184651_r() {
    }

    @Override
    public void startBomb(boolean server) {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack stack = this.getImitateCard();
            if (stack.func_190926_b()) {
                return;
            }
            Optional<Plants> opt = ImitaterCardItem.getImitatePlantType(stack);
            if (!opt.isPresent() || opt.get() == Plants.IMITATER) {
                return;
            }
            Plants plant = opt.get();
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.WAKE_UP.get());
            if (plant.isBlockPlant) {
                if (this.func_233580_cy_().func_177956_o() >= 2) {
                    BlockState state = BlockPlantCardItem.getBlockState(this.placeDirection, plant);
                    this.field_70170_p.func_180501_a(this.func_233580_cy_(), state, 11);
                }
                return;
            }
            if (plant.isOuterPlant) {
                if (this.targetPlantEntity.isPresent()) {
                    PlantCardItem.placeOuterPlant(this.targetPlantEntity.get(), plant, this.getImitateCard());
                    this.targetPlantEntity.get().outerSunCost = this.plantSunCost;
                }
                return;
            }
            if (plant.isUpgradePlant) {
                BlockPos pos;
                if (this.targetPlantEntity.isPresent()) {
                    PVZPlantEntity target = this.targetPlantEntity.get();
                    PVZPlantEntity plantEntity = PlantUtil.getPlantEntity(this.field_70170_p, plant);
                    this.copyDataToPlant(plantEntity);
                    plantEntity.plantSunCost = target.plantSunCost + this.plantSunCost;
                    if (!plant.isBigPlant) {
                        if (target.getOuterPlantType().isPresent()) {
                            plantEntity.setOuterPlantType(target.getOuterPlantType().get());
                        }
                        plantEntity.setPumpkinLife(target.getPumpkinLife());
                    }
                    PlantCardItem.summonPlantEntityByCard(plantEntity, stack);
                    this.field_70170_p.func_217376_c((Entity)plantEntity);
                    this.targetPlantEntity.get().func_70106_y();
                } else if (plant == Plants.CAT_TAIL && this.targetPos.isPresent() && this.field_70170_p.func_180495_p(pos = this.targetPos.get()).func_177230_c() == BlockRegister.LILY_PAD.get()) {
                    this.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                    PVZPlantEntity plantEntity = PlantUtil.getPlantEntity(this.field_70170_p, plant);
                    this.copyDataToPlant(plantEntity);
                    plantEntity.plantSunCost = this.plantSunCost + PlantUtil.getPlantSunCost(Plants.LILY_PAD);
                    PlantCardItem.summonPlantEntityByCard(plantEntity, stack);
                    this.field_70170_p.func_217376_c((Entity)plantEntity);
                }
                return;
            }
            PVZPlantEntity plantEntity = PlantUtil.getPlantEntity(this.field_70170_p, plant);
            this.copyDataToPlant(plantEntity);
            plantEntity.plantSunCost = this.plantSunCost;
            PlantCardItem.summonPlantEntityByCard(plantEntity, stack);
            this.field_70170_p.func_217376_c((Entity)plantEntity);
        } else {
            for (int i = 0; i < 3; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        }
    }

    public void copyDataToPlant(PVZPlantEntity plantEntity) {
        if (this.getOwnerUUID().isPresent()) {
            plantEntity.setOwnerUUID(this.getOwnerUUID().get());
        }
        plantEntity.setPlantLvl(this.getPlantLvl());
        plantEntity.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)plantEntity.getPlantHealth());
        plantEntity.func_70691_i(plantEntity.func_110138_aP());
        plantEntity.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        Entity ridingEntity = this.func_184187_bx();
        if (ridingEntity != null) {
            this.func_184210_p();
            plantEntity.func_184220_m(ridingEntity);
        }
        if (this.func_70638_az() != null) {
            plantEntity.func_70624_b(this.func_70638_az());
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70090_H()) {
                double speed = 0.25;
                this.func_213293_j(0.0, speed, 0.0);
            } else {
                this.func_213293_j(0.0, 0.0, 0.0);
            }
        }
    }

    public boolean func_189652_ae() {
        return false;
    }

    @Override
    public int getReadyTime() {
        return 40;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.7f, (float)1.25f);
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.IMITATER;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("imitate_plant_card")) {
            this.setImitateCard(ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("imitate_plant_card")));
        }
        if (compound.func_74764_b("target_plant_entity")) {
            this.targetPlantEntity = Optional.ofNullable((PVZPlantEntity)this.field_70170_p.func_73045_a(compound.func_74762_e("target_plant_entity")));
        }
        if (compound.func_74764_b("target_blockpos")) {
            CompoundNBT nbt = compound.func_74775_l("target_blockpos");
            this.targetPos = Optional.of(new BlockPos(nbt.func_74762_e("posX"), nbt.func_74762_e("posY"), nbt.func_74762_e("posZ")));
        }
        if (compound.func_74764_b("imitate_facing")) {
            this.placeDirection = Direction.values()[compound.func_74762_e("imitate_facing")];
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (!this.getImitateCard().func_190926_b()) {
            compound.func_218657_a("imitate_plant_card", (INBT)this.getImitateCard().func_196082_o());
        }
        if (this.targetPlantEntity.isPresent()) {
            compound.func_74768_a("target_plant_entity", this.targetPlantEntity.get().func_145782_y());
        }
        if (this.targetPos.isPresent()) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a("posX", this.targetPos.get().func_177958_n());
            nbt.func_74768_a("posY", this.targetPos.get().func_177956_o());
            nbt.func_74768_a("posZ", this.targetPos.get().func_177952_p());
        }
        compound.func_74768_a("imitate_facing", this.placeDirection.ordinal());
    }

    public void setImitateCard(ItemStack stack) {
        this.field_70180_af.func_187227_b(IMITATE_CARD, (Object)stack);
    }

    public ItemStack getImitateCard() {
        return (ItemStack)this.field_70180_af.func_187225_a(IMITATE_CARD);
    }
}

