/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.magic;

import com.hungteen.pvz.common.entity.drop.CoinEntity;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.entity.plant.base.PlantProducerEntity;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class MariGoldEntity
extends PlantProducerEntity {
    public MariGoldEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public void genSomething() {
        CoinEntity coin = (CoinEntity)((EntityType)EntityRegister.COIN.get()).func_200721_a(this.field_70170_p);
        coin.setAmount(this.getRandomAmount());
        EntityUtil.onMobEntityRandomPosSpawn((IWorld)this.field_70170_p, coin, this.func_233580_cy_(), 3);
    }

    protected void genSpecCoin(CoinEntity.CoinType type) {
        CoinEntity coin = (CoinEntity)((EntityType)EntityRegister.COIN.get()).func_200721_a(this.field_70170_p);
        coin.setAmountByType(type);
        EntityUtil.onMobEntityRandomPosSpawn((IWorld)this.field_70170_p, coin, this.func_233580_cy_(), 3);
    }

    @Override
    public void genSuper() {
        for (int i = 0; i < this.getSuperGenCnt(); ++i) {
            this.genSomething();
        }
        this.genSpecCoin(CoinEntity.CoinType.GOLD);
    }

    private int getRandomAmount() {
        int num = this.func_70681_au().nextInt(100);
        int silverNum = this.getSilverChance();
        int goldNum = this.getGoldChance();
        if (num < goldNum) {
            return CoinEntity.CoinType.GOLD.money;
        }
        if (num < silverNum + goldNum) {
            return CoinEntity.CoinType.SILVER.money;
        }
        return CoinEntity.CoinType.COPPER.money;
    }

    public float getAveGenAmount() {
        int silverNum = this.getSilverChance();
        int goldNum = this.getGoldChance();
        int copperNum = 100 - silverNum - goldNum;
        return (float)(silverNum * CoinEntity.CoinType.SILVER.money + goldNum * CoinEntity.CoinType.GOLD.money + copperNum * CoinEntity.CoinType.COPPER.money) * 1.0f / 100.0f;
    }

    public int getSilverChance() {
        return PlantUtil.getPlantAverageProgress((PVZPlantEntity)this, 10, 50);
    }

    public int getGoldChance() {
        int lvl = this.getPlantLvl();
        if (lvl <= 20) {
            int now = (lvl - 1) / 2;
            return now + 1;
        }
        return 10;
    }

    public int getSuperGenCnt() {
        return this.getThreeStage(3, 5, 7);
    }

    @Override
    public int getGenCD() {
        return 1200;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.8f, (float)1.6f);
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.MARIGOLD;
    }
}

