/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.magic;

import com.hungteen.pvz.PVZConfig;
import com.hungteen.pvz.common.entity.ai.goal.target.PVZNearestTargetGoal;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class StrangeCatEntity
extends PVZPlantEntity {
    public static final int REST_CD = 1000;
    public static final int ANIM_CD = 10;
    private int restTick = 1000;

    public StrangeCatEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
        this.isImmuneToWeak = true;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(0, (Goal)new PVZNearestTargetGoal((MobEntity)this, true, false, 5.0f, 5.0f));
    }

    @Override
    protected void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K) {
            if (EntityUtil.isEntityValid((Entity)this.func_70638_az())) {
                this.field_70749_g.func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
            }
            if (this.getAttackTime() > 0) {
                this.setAttackTime(this.getAttackTime() - 1);
            } else if (this.restTick == 0) {
                this.setAttackTime(0);
                if (EntityUtil.isEntityValid((Entity)this.func_70638_az())) {
                    this.performAttack(this.func_70638_az());
                }
            } else {
                this.setAttackTime(-1);
            }
            this.restTick = Math.max(0, this.restTick - 1);
        }
    }

    protected void performAttack(LivingEntity target) {
        target.func_70097_a((DamageSource)PVZDamageSource.normal((Entity)this), this.getAttackDamage());
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.BRUH.get());
        this.setAttackTime(10);
        this.restTick = 1000;
    }

    public static void handleCopyCat(LivingDeathEvent ev) {
        if (!ev.getEntity().field_70170_p.field_72995_K && ev.getSource().func_76346_g() instanceof StrangeCatEntity) {
            float range = 10.0f;
            int count = ev.getEntity().field_70170_p.func_217357_a(StrangeCatEntity.class, EntityUtil.getEntityAABB(ev.getEntity(), 10.0, 10.0)).size();
            if (count < (Integer)PVZConfig.COMMON_CONFIG.EntitySettings.PlantSetting.StrangeCatCount.get()) {
                ((StrangeCatEntity)ev.getSource().func_76346_g()).onSelfCopy(ev.getEntityLiving());
            }
        }
    }

    public void onSelfCopy(LivingEntity target) {
        StrangeCatEntity cat = (StrangeCatEntity)((EntityType)EntityRegister.STRANGE_CAT.get()).func_200721_a(this.field_70170_p);
        PlantUtil.copyPlantData(cat, this);
        EntityUtil.onEntitySpawn((IWorld)this.field_70170_p, (Entity)cat, target.func_233580_cy_());
    }

    @Override
    public void startSuperMode(boolean first) {
        super.startSuperMode(first);
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.BRUH.get());
        this.setAttackTime(10);
        EntityUtil.getRandomLivingInRange(this.field_70170_p, (LivingEntity)this, EntityUtil.getEntityAABB((Entity)this, 20.0, 20.0), this.getSuperAttackCount()).forEach(target -> target.func_70097_a((DamageSource)PVZDamageSource.normal((Entity)this), this.getAttackDamage()));
    }

    public boolean isResting() {
        return this.getAttackTime() < 0;
    }

    public float getAttackDamage() {
        return this.getAverageProgress(200.0f, 400.0f);
    }

    public int getSuperAttackCount() {
        return this.getThreeStage(4, 5, 6);
    }

    @Override
    public int getSuperTimeLength() {
        return 30;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return new EntitySize(0.8f, 1.0f, false);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("rest_tick", this.restTick);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("rest_tick")) {
            this.restTick = compound.func_74762_e("rest_tick");
        }
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.STRANGE_CAT;
    }
}

