/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.spear;

import com.hungteen.pvz.common.entity.bullet.AbstractBulletEntity;
import com.hungteen.pvz.common.entity.bullet.ThornEntity;
import com.hungteen.pvz.common.entity.plant.base.PlantShooterEntity;
import com.hungteen.pvz.common.entity.zombie.poolnight.BalloonZombieEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class CactusEntity
extends PlantShooterEntity {
    private static final DataParameter<Float> CACTUS_HEIGHT = EntityDataManager.func_187226_a(CactusEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(CactusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final float MAX_SEGMENT_NUM = 4.0f;
    public static final float SEGMENT_HEIGHT = 0.54f;
    private static final float MIN_SHOOT_HEIGHT = 1.25f;
    private static final float MAX_SHOOT_HEIGHT = 3.41f;
    protected static final double SHOOT_OFFSET = 0.3;

    public CactusEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CACTUS_HEIGHT, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(POWERED, (Object)false);
    }

    @Override
    public void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K) {
            LivingEntity target = this.func_70638_az();
            if (EntityUtil.isEntityValid((Entity)target)) {
                if (!this.isSuitableHeight((Entity)target)) {
                    float dh = 0.54f;
                    if (this.func_226278_cu_() < target.func_226278_cu_()) {
                        this.setCactusHeight(Math.min(this.getCactusHeight() + 0.54f, 2.16f));
                    } else {
                        this.setCactusHeight(Math.max(this.getCactusHeight() - 0.54f, 0.0f));
                    }
                }
            } else {
                this.setCactusHeight(0.0f);
            }
        }
    }

    public void func_184206_a(DataParameter<?> data) {
        super.func_184206_a(data);
        if (data.equals(CACTUS_HEIGHT)) {
            this.func_213323_x_();
        }
    }

    @Override
    public void shootBullet() {
        this.performShoot(0.3, 0.0, 0.0, this.getAttackTime() == 1, 0.0);
    }

    @Override
    protected AbstractBulletEntity createBullet() {
        ThornEntity thorn = new ThornEntity(this.field_70170_p, (LivingEntity)this);
        thorn.setThornType(ThornEntity.ThornTypes.NORMAL);
        thorn.setThornState(this.isCactusPowered() ? ThornEntity.ThornStates.POWER : ThornEntity.ThornStates.NORMAL);
        thorn.setExtraHitCount(this.isCactusPowered() ? this.getThornCount() : 1);
        return thorn;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (EntityUtil.canAttackEntity((Entity)this, source.func_76346_g())) {
            float damage = this.isCactusPowered() ? this.getAttackDamage() * 4.0f : this.getAttackDamage() * 2.0f;
            source.func_76346_g().func_70097_a((DamageSource)PVZDamageSource.causeThornDamage((Entity)this, (Entity)this), damage);
        }
        return super.func_70097_a(source, amount);
    }

    public int getThornCount() {
        return this.isPlantInStage(1) ? 2 : (this.isPlantInStage(2) ? 3 : 4);
    }

    public float getCurrentHeight() {
        return this.getCactusHeight() + 1.25f;
    }

    private boolean isSuitableHeight(Entity target) {
        double dx = target.func_226277_ct_() - this.func_226277_ct_();
        double ly = target.func_226278_cu_() - this.func_226278_cu_() - (double)this.getCurrentHeight();
        double ry = ly + (double)target.func_213302_cg();
        double dz = target.func_226281_cx_() - this.func_226281_cx_();
        double dis = Math.sqrt(dx * dx + dz * dz);
        double y = dis / this.getMaxShootAngle();
        return ly <= y && ry >= -y;
    }

    @Override
    public boolean canPlantTarget(Entity entity) {
        if (entity instanceof BalloonZombieEntity) {
            return true;
        }
        return super.canPlantTarget(entity);
    }

    @Override
    public boolean checkY(Entity target) {
        double dx = target.func_226277_ct_() - this.func_226277_ct_();
        double dz = target.func_226281_cx_() - this.func_226281_cx_();
        double dis = Math.sqrt(dx * dx + dz * dz);
        double y = dis / this.getMaxShootAngle();
        return this.func_226278_cu_() + (double)3.41f + y >= target.func_226278_cu_() && this.func_226278_cu_() + 1.25 - y <= target.func_226278_cu_() + (double)target.func_213302_cg();
    }

    @Override
    public void startShootAttack() {
        this.setAttackTime(1);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.8f, (float)(2.0f + this.getCactusHeight()));
    }

    @Override
    public void startSuperMode(boolean first) {
        super.startSuperMode(first);
        this.setCactusPowered(true);
    }

    @Override
    public boolean canStartSuperMode() {
        return super.canStartSuperMode() && !this.isCactusPowered();
    }

    @Override
    public int getSuperTimeLength() {
        return 20;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("cactus_powered")) {
            this.setCactusPowered(compound.func_74767_n("cactus_powered"));
        }
        if (compound.func_74764_b("cactus_height")) {
            this.setCactusHeight(compound.func_74760_g("cactus_height"));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("cactus_powered", this.isCactusPowered());
        compound.func_74776_a("cactus_height", this.getCactusHeight());
    }

    public float getCactusHeight() {
        return ((Float)this.field_70180_af.func_187225_a(CACTUS_HEIGHT)).floatValue();
    }

    public void setCactusHeight(float h) {
        this.field_70180_af.func_187227_b(CACTUS_HEIGHT, (Object)Float.valueOf(h));
    }

    public boolean isCactusPowered() {
        return (Boolean)this.field_70180_af.func_187225_a(POWERED);
    }

    public void setCactusPowered(boolean is) {
        this.field_70180_af.func_187227_b(POWERED, (Object)is);
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.CACTUS;
    }
}

