/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.spear;

import com.hungteen.pvz.common.entity.ai.goal.target.PVZGlobalTargetGoal;
import com.hungteen.pvz.common.entity.bullet.AbstractBulletEntity;
import com.hungteen.pvz.common.entity.bullet.ThornEntity;
import com.hungteen.pvz.common.entity.plant.base.PlantShooterEntity;
import com.hungteen.pvz.common.entity.zombie.poolnight.BalloonZombieEntity;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.MathUtil;
import com.hungteen.pvz.utils.enums.Plants;
import java.util.HashSet;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;

public class CatTailEntity
extends PlantShooterEntity {
    public HashSet<ThornEntity> thorns = new HashSet();
    private int powerCount = 0;
    private int powerTick = 0;
    private final int POWER_CD = 200;

    public CatTailEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(2, (Goal)new SwimGoal((MobEntity)this));
    }

    @Override
    protected void addTargetGoals() {
        this.field_70715_bh.func_75776_a(0, (Goal)new PVZGlobalTargetGoal((MobEntity)this, true, false, this.getShootRange(), this.getShootRange()));
    }

    @Override
    public void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K) {
            if (this.powerTick > 0) {
                --this.powerTick;
            }
            HashSet tmp = new HashSet();
            this.thorns.forEach(thorn -> {
                if (EntityUtil.isEntityValid(thorn) && thorn.isInControl()) {
                    thorn.setThornTarget(this.func_70638_az());
                    tmp.add(thorn);
                }
            });
            this.thorns.clear();
            this.thorns = tmp;
        }
    }

    @Override
    public void shootBullet() {
        this.performShoot(0.0, 0.0, 0.2, true, 0.0);
    }

    @Override
    protected AbstractBulletEntity createBullet() {
        ThornEntity thorn = new ThornEntity(this.field_70170_p, (LivingEntity)this);
        thorn.setThornType(this.isPlantInSuperMode() ? ThornEntity.ThornTypes.AUTO : ThornEntity.ThornTypes.GUIDE);
        thorn.setThornState(this.getThornShootState());
        thorn.setExtraHitCount(this.getExtraAttackCount());
        this.thorns.add(thorn);
        return thorn;
    }

    @Override
    public boolean canPlantTarget(Entity entity) {
        if (entity instanceof BalloonZombieEntity) {
            return true;
        }
        return super.canPlantTarget(entity);
    }

    @Override
    public void startSuperMode(boolean first) {
        super.startSuperMode(first);
        this.powerCount += this.getPowerThornCount();
    }

    protected ThornEntity.ThornStates getThornShootState() {
        if (this.powerCount > 0 && this.powerTick == 0) {
            this.powerTick = this.POWER_CD;
            --this.powerCount;
            return ThornEntity.ThornStates.POWER;
        }
        return ThornEntity.ThornStates.NORMAL;
    }

    @Override
    protected boolean canAttackNow() {
        return this.getAttackTime() > 0 && this.getAttackTime() % this.getAnimCD() == 0;
    }

    @Override
    public boolean checkY(Entity target) {
        return true;
    }

    public int getPowerThornCount() {
        return this.getThreeStage(1, 2, 3);
    }

    public int getExtraAttackCount() {
        return MathUtil.getProgressByDif(5, 1, this.getPlantLvl(), 20, 1, 4);
    }

    @Override
    public float getAttackDamage() {
        return this.getAverageProgress(2.0f, 6.0f);
    }

    public int getAnimCD() {
        return 8;
    }

    @Override
    public void startShootAttack() {
        this.setAttackTime(this.getAnimCD() * 2);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.8f, (float)1.4f);
    }

    @Override
    public float getShootRange() {
        return 40.0f;
    }

    @Override
    public float getBulletSpeed() {
        return 0.0f;
    }

    @Override
    public int getSuperTimeLength() {
        return 40;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("power_thorn_count")) {
            this.powerCount = compound.func_74762_e("power_thorn_count");
        }
        if (compound.func_74764_b("power_shoot_tick")) {
            this.powerTick = compound.func_74762_e("power_shoot_tick");
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("power_thorn_count", this.powerCount);
        compound.func_74768_a("power_shoot_tick", this.powerTick);
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.CAT_TAIL;
    }
}

