/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.spear;

import com.hungteen.pvz.api.interfaces.IHasWheel;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.enums.Plants;
import javax.annotation.Nonnull;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class SpikeWeedEntity
extends PVZPlantEntity {
    private static final DataParameter<Integer> SPIKE_NUM = EntityDataManager.func_187226_a(SpikeWeedEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final int ATTACK_ANIM_CD = 10;

    public SpikeWeedEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
        this.setSpikeNum(this.getSpikesCount());
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SPIKE_NUM, (Object)1);
    }

    @Override
    protected void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K) {
            if (this.getSpikeNum() <= 0) {
                this.func_70106_y();
            }
            if (this.getAttackTime() > 0) {
                this.setAttackTime(this.getAttackTime() - 1);
            }
            if (this.getExistTick() % this.getAttackCD() == 10) {
                this.spikeAttack();
            }
        }
    }

    public void spikeAttack() {
        float range = 1.0f;
        EntityUtil.getTargetableEntities((Entity)this, EntityUtil.getEntityAABB((Entity)this, 1.0, 1.0)).forEach(target -> this.spikeNormalAttack((Entity)target));
    }

    public void spikeNormalAttack(@Nonnull Entity target) {
        if (target instanceof IHasWheel) {
            ((IHasWheel)target).spikeWheelBy((LivingEntity)this);
            this.setSpikeNum(this.getSpikeNum() - 1);
        } else {
            target.func_70097_a((DamageSource)PVZDamageSource.causeThornDamage((Entity)this), this.getAttackDamage());
        }
        this.setAttackTime(10);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source instanceof PVZDamageSource && ((PVZDamageSource)source).isCrushDamage() && this.getSpikeNum() > 0) {
            this.setSpikeNum(this.getSpikeNum() - 1);
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public void startSuperMode(boolean first) {
        super.startSuperMode(first);
        this.setSpikeNum(this.getSpikeNum() + this.getSuperSpikeCount());
    }

    @Override
    public boolean isPlantImmuneTo(DamageSource source) {
        return super.isPlantImmuneTo(source) || !(source instanceof PVZDamageSource) && !source.func_76352_a();
    }

    @Override
    protected boolean shouldCollideWithEntity(LivingEntity target) {
        if (EntityUtil.canTargetEntity((Entity)this, (Entity)target)) {
            return false;
        }
        return super.shouldCollideWithEntity(target);
    }

    @Override
    public boolean canBeTargetBy(LivingEntity living) {
        return false;
    }

    public float getAttackDamage() {
        return PlantUtil.getPlantAverageProgress((PVZPlantEntity)this, 2.0f, 6.0f);
    }

    public int getSuperSpikeCount() {
        return this.isPlantInStage(1) ? 3 : (this.isPlantInStage(2) ? 6 : 9);
    }

    public int getAttackCD() {
        return 40;
    }

    public int getSpikesCount() {
        return 1;
    }

    @Override
    public int getSuperTimeLength() {
        return 20;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("spike_num")) {
            this.setSpikeNum(compound.func_74762_e("spike_num"));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("spike_num", this.getSpikeNum());
    }

    public int getSpikeNum() {
        return (Integer)this.field_70180_af.func_187225_a(SPIKE_NUM);
    }

    public void setSpikeNum(int num) {
        this.field_70180_af.func_187227_b(SPIKE_NUM, (Object)num);
    }

    @Override
    public Plants getUpgradePlantType() {
        return Plants.SPIKE_ROCK;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.SPIKE_WEED;
    }
}

