/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.toxic;

import com.hungteen.pvz.common.entity.bullet.AbstractBulletEntity;
import com.hungteen.pvz.common.entity.bullet.FumeEntity;
import com.hungteen.pvz.common.entity.plant.base.PlantShooterEntity;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class FumeShroomEntity
extends PlantShooterEntity {
    protected static final double SHOOT_OFFSET = 0.2;

    public FumeShroomEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public void shootBullet() {
        if (this.isPlantInSuperMode()) {
            this.performShoot(0.2, 0.0, 0.0, this.getExistTick() % 5 == 0, 0.0);
        } else {
            this.performShoot(0.2, 0.0, 0.0, this.getAttackTime() == 1, 0.0);
        }
    }

    @Override
    protected AbstractBulletEntity createBullet() {
        return new FumeEntity(this.field_70170_p, (LivingEntity)this);
    }

    @Override
    protected SoundEvent getShootSound() {
        return (SoundEvent)SoundRegister.FUME.get();
    }

    @Override
    public void startShootAttack() {
        this.setAttackTime(1);
    }

    @Override
    public int getSuperTimeLength() {
        return this.isPlantInStage(1) ? 40 : (this.isPlantInStage(2) ? 60 : 80);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.8f, (float)1.25f);
    }

    @Override
    public float getShootRange() {
        return 15.0f;
    }

    @Override
    public Plants getUpgradePlantType() {
        return Plants.GLOOM_SHROOM;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.FUME_SHROOM;
    }
}

