/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.toxic;

import com.hungteen.pvz.common.advancement.trigger.EntityEffectAmountTrigger;
import com.hungteen.pvz.common.entity.bullet.AbstractBulletEntity;
import com.hungteen.pvz.common.entity.bullet.itembullet.SporeEntity;
import com.hungteen.pvz.common.entity.plant.base.PlantShooterEntity;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.MathUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class PuffShroomEntity
extends PlantShooterEntity {
    protected static final double SHOOT_OFFSET = 0.1;

    public PuffShroomEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public void shootBullet() {
        if (this.isPlantInSuperMode()) {
            this.performShoot(0.1, 0.0, -0.2f, this.getExistTick() % 5 == 0, 0.0);
        } else {
            this.performShoot(0.1, 0.0, -0.2f, this.getAttackTime() == 1, 0.0);
        }
    }

    @Override
    protected AbstractBulletEntity createBullet() {
        return new SporeEntity(this.field_70170_p, (LivingEntity)this);
    }

    @Override
    protected SoundEvent getShootSound() {
        return (SoundEvent)SoundRegister.PUFF.get();
    }

    @Override
    public void startSuperMode(boolean first) {
        super.startSuperMode(first);
        if (first) {
            PlayerEntity player;
            int cnt = 1;
            int range = 20;
            for (PuffShroomEntity shroom2 : this.field_70170_p.func_175647_a(PuffShroomEntity.class, EntityUtil.getEntityAABB((Entity)this, 20.0, 20.0), shroom -> this.canSuperTogether((PuffShroomEntity)shroom))) {
                if (!shroom2.canStartSuperMode()) continue;
                shroom2.startSuperMode(false);
                if (++cnt < this.getMaxSuperCnt()) continue;
                break;
            }
            if ((player = EntityUtil.getEntityOwner(this.field_70170_p, (Entity)this)) != null && player instanceof ServerPlayerEntity) {
                EntityEffectAmountTrigger.INSTANCE.trigger((ServerPlayerEntity)player, (Entity)this, cnt);
            }
        }
    }

    protected boolean canSuperTogether(PuffShroomEntity entity) {
        if (EntityUtil.canTargetEntity((Entity)this, (Entity)entity) || entity.getPlantEnumName() != this.getPlantEnumName()) {
            return false;
        }
        return this.getOwnerUUID().isPresent() && entity.getOwnerUUID().isPresent() && entity.getOwnerUUID().get().equals(this.getOwnerUUID().get());
    }

    public int getMaxSuperCnt() {
        return this.isPlantInStage(1) ? 10 : (this.isPlantInStage(2) ? 15 : 25);
    }

    @Override
    public void startShootAttack() {
        this.setAttackTime(1);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.5f, (float)0.5f);
    }

    @Override
    public int getSuperTimeLength() {
        return 20;
    }

    @Override
    public float getPlantHealth() {
        return MathUtil.getProgressAverage(this.getPlantLvl(), 20, 30, 50);
    }

    @Override
    public float getShootRange() {
        return 10.0f;
    }

    @Override
    public float getShootHeight() {
        return 2.0f;
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.PUFF_SHROOM;
    }
}

