/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.plant.toxic;

import com.hungteen.pvz.common.entity.bullet.AbstractBulletEntity;
import com.hungteen.pvz.common.entity.bullet.itembullet.SporeEntity;
import com.hungteen.pvz.common.entity.plant.base.PlantShooterEntity;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.MathUtil;
import com.hungteen.pvz.utils.enums.Plants;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class ScaredyShroomEntity
extends PlantShooterEntity {
    private static final DataParameter<Integer> SCARE_TIME = EntityDataManager.func_187226_a(ScaredyShroomEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final double SHOOT_OFFSET = 0.2;
    public static final int SCARE_ANIM_CD = 15;

    public ScaredyShroomEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SCARE_TIME, (Object)0);
    }

    @Override
    public void normalPlantTick() {
        super.normalPlantTick();
        if (!this.field_70170_p.field_72995_K) {
            if (EntityUtil.isEntityValid((Entity)this.func_70638_az())) {
                double dis = this.getScareDistance();
                if (this.func_70068_e((Entity)this.func_70638_az()) <= dis * dis) {
                    this.setScareTime(MathHelper.func_76125_a((int)(this.getScareTime() + 1), (int)0, (int)15));
                    return;
                }
            }
            this.setScareTime(MathHelper.func_76125_a((int)(this.getScareTime() - 1), (int)0, (int)15));
        }
    }

    public void func_184206_a(DataParameter<?> data) {
        super.func_184206_a(data);
        if (data.equals(SCARE_TIME)) {
            this.func_213323_x_();
        }
    }

    @Override
    public boolean canShoot() {
        return super.canShoot() && !this.isScared();
    }

    @Override
    public void shootBullet() {
        if (this.isPlantInSuperMode()) {
            int cnt = this.getSuperShootCount();
            for (int i = 0; i < cnt; ++i) {
                float offset = MathUtil.getRandomFloat(this.func_70681_au()) / 3.0f;
                float offsetH = MathUtil.getRandomFloat(this.func_70681_au()) / 3.0f;
                this.performShoot(0.2, offset, offsetH, this.getExistTick() % 10 == 0, 0.0);
            }
        } else {
            this.performShoot(0.2, 0.0, 0.0, this.getAttackTime() == 1, 0.0);
        }
    }

    @Override
    protected AbstractBulletEntity createBullet() {
        return new SporeEntity(this.field_70170_p, (LivingEntity)this);
    }

    @Override
    protected SoundEvent getShootSound() {
        return (SoundEvent)SoundRegister.PUFF.get();
    }

    public int getSuperShootCount() {
        int min = this.isPlantInStage(3) ? 2 : 1;
        int max = this.isPlantInStage(1) ? 2 : 3;
        return MathUtil.getRandomMinMax(this.func_70681_au(), min, max);
    }

    public float getScareDistance() {
        return MathUtil.getProgressByDif(4, -1, this.getPlantLvl(), 20, 5, 1);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.6f, (float)(1.6f - (float)this.getScareTime() * 1.0f / 15.0f));
    }

    @Override
    public void startShootAttack() {
        this.setAttackTime(1);
    }

    @Override
    public int getSuperTimeLength() {
        return 100;
    }

    @Override
    public float getShootRange() {
        return 35.0f;
    }

    public boolean isScared() {
        return this.getScareTime() > 0;
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("scare_time", this.getScareTime());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("scare_time")) {
            this.setScareTime(compound.func_74762_e("scare_time"));
        }
    }

    public int getScareTime() {
        return (Integer)this.field_70180_af.func_187225_a(SCARE_TIME);
    }

    public void setScareTime(int time) {
        this.field_70180_af.func_187227_b(SCARE_TIME, (Object)time);
    }

    @Override
    public Plants getPlantEnumName() {
        return Plants.SCAREDY_SHROOM;
    }
}

