/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.zombie;

import com.hungteen.pvz.PVZConfig;
import com.hungteen.pvz.api.enums.PVZGroupType;
import com.hungteen.pvz.api.interfaces.IPVZZombie;
import com.hungteen.pvz.client.particle.ParticleUtil;
import com.hungteen.pvz.common.advancement.trigger.CharmZombieTrigger;
import com.hungteen.pvz.common.entity.ai.goal.PVZLookRandomlyGoal;
import com.hungteen.pvz.common.entity.ai.goal.PVZSwimGoal;
import com.hungteen.pvz.common.entity.ai.goal.ZombieBreakPlantBlockGoal;
import com.hungteen.pvz.common.entity.ai.goal.attack.PVZZombieAttackGoal;
import com.hungteen.pvz.common.entity.ai.goal.target.PVZNearestTargetGoal;
import com.hungteen.pvz.common.entity.ai.navigator.ZombiePathNavigator;
import com.hungteen.pvz.common.entity.bullet.AbstractBulletEntity;
import com.hungteen.pvz.common.entity.drop.CoinEntity;
import com.hungteen.pvz.common.entity.drop.SunEntity;
import com.hungteen.pvz.common.entity.misc.bowling.AbstractBowlingEntity;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.entity.plant.enforce.SquashEntity;
import com.hungteen.pvz.common.entity.plant.spear.SpikeWeedEntity;
import com.hungteen.pvz.common.entity.zombie.body.ZombieDropBodyEntity;
import com.hungteen.pvz.common.entity.zombie.roof.BungeeZombieEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.common.world.data.PVZInvasionData;
import com.hungteen.pvz.data.loot.PVZLoot;
import com.hungteen.pvz.register.BlockRegister;
import com.hungteen.pvz.register.EffectRegister;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.ItemRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.AlgorithmUtil;
import com.hungteen.pvz.utils.ConfigUtil;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.ZombieUtil;
import com.hungteen.pvz.utils.enums.InvasionEvents;
import com.hungteen.pvz.utils.enums.Ranks;
import com.hungteen.pvz.utils.interfaces.ICanAttract;
import com.hungteen.pvz.utils.others.WeightList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDamageEvent;

public abstract class PVZZombieEntity
extends MonsterEntity
implements IPVZZombie {
    private static final DataParameter<Integer> ZOMBIE_TYPE = EntityDataManager.func_187226_a(PVZZombieEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<UUID>> OWNER_UUID = EntityDataManager.func_187226_a(PVZZombieEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Integer> ZOMBIE_STATES = EntityDataManager.func_187226_a(PVZZombieEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ATTACK_TIME = EntityDataManager.func_187226_a(PVZZombieEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ANIM_TIME = EntityDataManager.func_187226_a(PVZZombieEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Float> DEFENCE_LIFE = EntityDataManager.func_187226_a(PVZZombieEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> ZOMBIE_LEVEL = EntityDataManager.func_187226_a(PVZZombieEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static WeightList<DropType> dropSpecialList;
    private static final int CHARM_FLAG = 0;
    private static final int MINI_FLAG = 1;
    private static final int HAND_FLAG = 2;
    private static final int HEAD_FLAG = 3;
    public static final int PERFORM_ATTACK_CD = 10;
    public static final int RISING_CD = 30;
    protected boolean needRising = false;
    protected boolean hasDirectDefence = false;
    public boolean canCollideWithZombie = true;
    protected boolean canSpawnDrop = true;
    protected boolean canBeCold = true;
    protected boolean canBeFrozen = true;
    protected boolean canBeCharm = true;
    protected boolean canBeButter = true;
    protected boolean canBeMini = true;
    protected boolean canBeInvis = true;
    protected boolean canBeStealByBungee = true;
    protected boolean canBeRemove = true;
    protected boolean canLostHand = true;
    protected boolean canLostHead = true;
    protected boolean canHelpAttack = true;
    protected int maxDeathTime = 20;
    protected int climbUpTick = 0;
    protected int maxClimbUpTick = 5;

    public PVZZombieEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_213323_x_();
        this.field_70728_aV = ZombieUtil.caculateZombieXp(this);
        dropSpecialList = this.getDropSpecialList();
        this.onLevelChanged();
        this.func_184644_a(PathNodeType.DANGER_FIRE, 6.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 6.0f);
        this.func_184644_a(PathNodeType.DAMAGE_OTHER, 6.0f);
        this.func_184644_a(PathNodeType.UNPASSABLE_RAIL, 6.0f);
        this.func_184644_a(PathNodeType.LEAVES, 4.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ZOMBIE_TYPE, (Object)Type.NORMAL.ordinal());
        this.field_70180_af.func_187214_a(OWNER_UUID, Optional.empty());
        this.field_70180_af.func_187214_a(ZOMBIE_STATES, (Object)0);
        this.field_70180_af.func_187214_a(ATTACK_TIME, (Object)0);
        this.field_70180_af.func_187214_a(DEFENCE_LIFE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(ZOMBIE_LEVEL, (Object)1);
        this.field_70180_af.func_187214_a(ANIM_TIME, (Object)0);
    }

    public static AttributeModifierMap createZombieAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233823_f_, 6.0).func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233819_b_, 50.0).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233821_d_, (double)0.2f).func_233815_a_(Attributes.field_233822_e_, 0.0).func_233813_a_();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(8, (Goal)new PVZLookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(7, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new PVZSwimGoal((MobEntity)this));
        this.registerAttackGoals();
        this.registerTargetGoals();
    }

    protected void registerAttackGoals() {
        this.field_70714_bg.func_75776_a(3, (Goal)new PVZZombieAttackGoal(this, true));
        this.field_70714_bg.func_75776_a(6, (Goal)new ZombieBreakPlantBlockGoal((Block)BlockRegister.FLOWER_POT.get(), this, 1.0, 10));
    }

    protected void registerTargetGoals() {
        this.field_70715_bh.func_75776_a(0, (Goal)new PVZNearestTargetGoal((MobEntity)this, true, true, 60.0f, 30.0f));
    }

    protected PathNavigator func_175447_b(World world) {
        return new ZombiePathNavigator((MobEntity)this, world);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        if (!this.field_70170_p.field_72995_K) {
            this.setZombieType(this.getSpawnType());
            this.getSpawnSound().ifPresent(s -> EntityUtil.playSound((Entity)this, s));
            this.setZombieLevel(ZombieUtil.caculateZombieLevel(this));
            this.updateAttributes();
            if (this.needRising) {
                this.setAnimTime(-30);
                this.func_195064_c(new EffectInstance(Effects.field_76421_d, 40, 20, false, false));
            }
            if (this.field_70170_p.func_234923_W_() == World.field_234918_g_) {
                PVZInvasionData data = PVZInvasionData.getOverWorldInvasionData(this.field_70170_p);
                if (!this.needRising && this.canBeMini() && data.hasEvent(InvasionEvents.MINI)) {
                    this.onZombieBeMini();
                }
                if (this.canBeInvis() && data.hasEvent(InvasionEvents.INVIS)) {
                    this.func_195064_c(new EffectInstance(Effects.field_76441_p, 1000000, 10, false, false));
                }
            }
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected Type getSpawnType() {
        int t = this.func_70681_au().nextInt(100);
        int a = (Integer)PVZConfig.COMMON_CONFIG.EntitySettings.ZombieSetting.ZombieSuperChance.get();
        int b = (Integer)PVZConfig.COMMON_CONFIG.EntitySettings.ZombieSetting.ZombieSunChance.get();
        return t < a ? Type.SUPER : (t < a + b ? Type.SUN : Type.NORMAL);
    }

    protected void updateAttributes() {
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(6.0);
        this.func_110148_a(Attributes.field_233819_b_).func_111128_a(30.0);
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.2f);
        this.func_110148_a(Attributes.field_233820_c_).func_111128_a(1.0);
        EntityUtil.setLivingMaxHealthAndHeal((LivingEntity)this, this.getLife());
        this.setDefenceLife(this.getExtraLife());
        this.onLevelChanged();
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.field_70170_p.func_217381_Z().func_76320_a("PVZ Zombie Tick");
        this.zombieTick();
        this.field_70170_p.func_217381_Z().func_76319_b();
        if (this.canZombieNormalUpdate()) {
            this.field_70170_p.func_217381_Z().func_76320_a("PVZ Normal Zombie Tick");
            this.normalZombieTick();
            this.field_70170_p.func_217381_Z().func_76319_b();
        }
    }

    public void zombieTick() {
        if (this.field_70173_aa <= 2) {
            this.func_213323_x_();
        }
        if (this.isZombieRising()) {
            this.setAnimTime(this.getAnimTime() + 1);
            if (this.field_70170_p.field_72995_K) {
                ParticleUtil.spawnSplash(this.field_70170_p, this.func_213303_ch(), 1);
            }
        }
    }

    public void normalZombieTick() {
        if (!this.field_70170_p.field_72995_K) {
            this.setAnimTime(Math.max(0, this.getAnimTime() - 1));
            if (this.canClimbWalls()) {
                if (++this.climbUpTick <= this.maxClimbUpTick) {
                    Vector3d vec = this.func_213322_ci();
                    this.func_213293_j(vec.field_72450_a, 0.3, vec.field_72449_c);
                }
            } else {
                this.climbUpTick = 0;
            }
        }
    }

    public void onSpawnedByPlayer(PlayerEntity player, int lvl) {
        this.setOwnerUUID(player.func_110124_au());
        this.updateZombieLevel(lvl);
    }

    public void updateZombieLevel(int lvl) {
        if (this.getZombieLevel() != lvl) {
            this.setZombieLevel(lvl);
        }
    }

    public boolean canClimbWalls() {
        return this.field_70123_F;
    }

    private void onLostHand(DamageSource source) {
        this.lostHand(true);
        ZombieDropBodyEntity body = (ZombieDropBodyEntity)((EntityType)EntityRegister.ZOMBIE_DROP_BODY.get()).func_200721_a(this.field_70170_p);
        body.droppedByOwner(this, source, ZombieDropBodyEntity.BodyType.HAND);
        this.field_70170_p.func_217376_c((Entity)body);
    }

    private void onLostHead(DamageSource source) {
        this.lostHead(true);
        ZombieDropBodyEntity body = (ZombieDropBodyEntity)((EntityType)EntityRegister.ZOMBIE_DROP_BODY.get()).func_200721_a(this.field_70170_p);
        body.droppedByOwner(this, source, ZombieDropBodyEntity.BodyType.HEAD);
        this.field_70170_p.func_217376_c((Entity)body);
    }

    protected void onFallBody(DamageSource source) {
        ZombieDropBodyEntity body = (ZombieDropBodyEntity)((EntityType)EntityRegister.ZOMBIE_DROP_BODY.get()).func_200721_a(this.field_70170_p);
        body.droppedByOwner(this, source, ZombieDropBodyEntity.BodyType.BODY);
        body.setMaxLiveTick(40);
        this.setBodyStates(body);
        this.field_70170_p.func_217376_c((Entity)body);
    }

    protected void setBodyStates(ZombieDropBodyEntity body) {
        body.setMini(this.isMiniZombie());
    }

    public void onZombieBeMini() {
        this.setMiniZombie(true);
        float healthDec = 0.6f;
        EntityUtil.setLivingMaxHealthAndHeal((LivingEntity)this, this.func_110138_aP() * 0.6f);
        this.setDefenceLife(this.getDefenceLife() * 0.6f);
        this.func_195064_c(new EffectInstance(Effects.field_76424_c, 1000000, 0, false, false));
        this.func_195064_c(new EffectInstance(Effects.field_76420_g, 1000000, 0, false, false));
    }

    public void onLevelChanged() {
    }

    @Override
    public int getAttackCD() {
        if (!this.canZombieNormalUpdate()) {
            return 10000000;
        }
        int cd = 20;
        if (this.func_70644_a((Effect)EffectRegister.COLD_EFFECT.get())) {
            int lvl = this.func_70660_b((Effect)EffectRegister.COLD_EFFECT.get()).func_76458_c();
            cd += 3 * lvl;
        }
        return cd;
    }

    public float getHurtReduction() {
        int lvl = this.getZombieLevel();
        float inc = 0.2f;
        return lvl >= 20 ? 0.2f : 1.0f / (1.0f + 0.2f * (float)(lvl - 1));
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.isMiniZombie() ? EntitySize.func_220314_b((float)0.3f, (float)0.6f) : EntitySize.func_220314_b((float)0.8f, (float)1.98f);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (cause instanceof PVZDamageSource && ((PVZDamageSource)cause).func_76364_f() instanceof AbstractBowlingEntity && ((PVZDamageSource)cause).getDamageCount() > 0) {
            this.canSpawnDrop = false;
        }
        if (ConfigUtil.enableZombieDropParts() && !this.field_70170_p.field_72995_K) {
            this.onFallBody(cause);
        }
    }

    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        if (ConfigUtil.enableZombieDropParts() || this.field_70725_aQ >= this.maxDeathTime) {
            for (int i = 0; i < 5; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, this.func_226282_d_(1.0), this.func_226279_cv_(), this.func_226287_g_(1.0), d0, d1, d2);
            }
            this.onZombieRemove();
            this.func_70106_y();
        }
    }

    protected void onZombieRemove() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.getZombieType() == Type.SUPER) {
                this.dropEnergy();
            } else if (this.getZombieType() == Type.SUN) {
                this.dropSun();
            } else if (this.getZombieType() == Type.BEARD) {
                // empty if block
            }
            if (this.canSpawnDrop) {
                this.spawnSpecialDrops();
            }
        }
    }

    protected void dropEnergy() {
        EntityUtil.createEntityAndSpawn(this.field_70170_p, (EntityType)EntityRegister.ENERGY.get(), this.func_233580_cy_().func_177984_a());
    }

    protected void dropSun() {
        int num = this.func_70681_au().nextInt(8) + 3;
        for (int i = 0; i < num; ++i) {
            SunEntity.spawnSunRandomly(this.field_70170_p, this.func_233580_cy_().func_177984_a(), 25, 2);
        }
    }

    protected void spawnSpecialDrops() {
        dropSpecialList.getRandomItem(this.field_70146_Z).ifPresent(type -> this.doZombieDrop((DropType)((Object)type)));
    }

    private void doZombieDrop(DropType type) {
        switch (type) {
            case COPPER: {
                CoinEntity.spawnCoin(this.field_70170_p, this.func_233580_cy_(), CoinEntity.CoinType.COPPER);
                break;
            }
            case SILVER: {
                CoinEntity.spawnCoin(this.field_70170_p, this.func_233580_cy_(), CoinEntity.CoinType.SILVER);
                break;
            }
            case GOLD: {
                CoinEntity.spawnCoin(this.field_70170_p, this.func_233580_cy_(), CoinEntity.CoinType.GOLD);
                break;
            }
            case JEWEL: {
                EntityUtil.createEntityAndSpawn(this.field_70170_p, (EntityType)EntityRegister.JEWEL.get(), this.func_233580_cy_());
                break;
            }
            case CHOCOLATE: {
                ItemEntity chocolate = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), new ItemStack((IItemProvider)ItemRegister.CHOCOLATE.get()));
                EntityUtil.playSound((Entity)chocolate, (SoundEvent)SoundRegister.JEWEL_DROP.get());
                this.field_70170_p.func_217376_c((Entity)chocolate);
                break;
            }
        }
    }

    protected WeightList<DropType> getDropSpecialList() {
        int p = (Integer)PVZConfig.COMMON_CONFIG.EntitySettings.ZombieSetting.ZombieDropMultiper.get();
        int pp = p * p;
        return WeightList.of(pp * pp, Pair.of((Object)((Object)DropType.SILVER), (Object)(p * p * p)), Pair.of((Object)((Object)DropType.GOLD), (Object)(p * p)), Pair.of((Object)((Object)DropType.JEWEL), (Object)p), Pair.of((Object)((Object)DropType.CHOCOLATE), (Object)p));
    }

    public boolean checkCanZombieTarget(Entity target) {
        return EntityUtil.checkCanEntityBeTarget((Entity)this, target) && this.canZombieTarget(target);
    }

    public boolean checkCanZombieAttack(Entity target) {
        return EntityUtil.checkCanEntityBeAttack((Entity)this, target) && this.canZombieTarget(target);
    }

    public boolean canBeTargetBy(LivingEntity living) {
        return true;
    }

    public boolean canZombieTarget(Entity target) {
        if (target instanceof PVZPlantEntity) {
            return ((PVZPlantEntity)target).canBeTargetBy((LivingEntity)this);
        }
        if (target instanceof PVZZombieEntity) {
            return ((PVZZombieEntity)target).canBeTargetBy((LivingEntity)this);
        }
        return true;
    }

    public boolean canBreakPlantBlock() {
        return !this.isCharmed();
    }

    public boolean canZombieBeRemoved() {
        return this.canBeRemove;
    }

    public boolean canHelpAttack() {
        return this.canHelpAttack;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (source instanceof PVZDamageSource) {
            this.field_70172_ad = 0;
        }
        boolean flag = super.func_70097_a(source, amount *= this.getHurtReduction());
        if (ConfigUtil.enableZombieDropParts() && !this.field_70170_p.field_72995_K) {
            if (this.hasHand() && this.canLostHand() && this.checkCanLostHand()) {
                this.onLostHand(source);
            }
            if (this.hasHead() && this.canLostHead() && this.checkCanLostHead()) {
                this.onLostHead(source);
            }
        }
        return flag;
    }

    protected void dealDamageEffectToZombie(PVZDamageSource source) {
        if (source.isDefended()) {
            return;
        }
        for (EffectInstance effect : source.getEffects()) {
            EntityUtil.addPotionEffect((Entity)this, effect);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        int i;
        entityIn.field_70172_ad = 0;
        this.setAnimTime(10);
        float f = (float)this.func_233637_b_(Attributes.field_233823_f_);
        float f1 = (float)this.func_233637_b_(Attributes.field_233824_g_);
        if (entityIn instanceof LivingEntity) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (CreatureAttribute)((LivingEntity)entityIn).func_70668_bt());
            f1 += (float)EnchantmentHelper.func_77501_a((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.func_90036_a((LivingEntity)this)) > 0) {
            entityIn.func_70015_d(i * 4);
        }
        if (flag = entityIn.func_70097_a((DamageSource)this.getZombieAttackDamageSource(), this.getModifyAttackDamage(entityIn, f))) {
            if (f1 > 0.0f && entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).func_233627_a_(f1 * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
            }
            if (entityIn instanceof PlayerEntity) {
                PlayerEntity playerentity = (PlayerEntity)entityIn;
                this.maybeDisableShield(playerentity, this.func_184614_ca(), playerentity.func_184587_cr() ? playerentity.func_184607_cu() : ItemStack.field_190927_a);
            }
            this.func_174815_a((LivingEntity)this, entityIn);
            this.func_130011_c(entityIn);
        }
        return flag;
    }

    private void maybeDisableShield(PlayerEntity p_233655_1_, ItemStack p_233655_2_, ItemStack p_233655_3_) {
        if (!p_233655_2_.func_190926_b() && !p_233655_3_.func_190926_b() && p_233655_2_.func_77973_b() instanceof AxeItem && p_233655_3_.func_77973_b() == Items.field_185159_cQ) {
            float f = 0.25f + (float)EnchantmentHelper.func_185293_e((LivingEntity)this) * 0.05f;
            if (this.field_70146_Z.nextFloat() < f) {
                p_233655_1_.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                this.field_70170_p.func_72960_a((Entity)p_233655_1_, (byte)30);
            }
        }
    }

    public boolean func_70648_aU() {
        return true;
    }

    public static void damageZombieDefence(LivingDamageEvent ev) {
        PVZZombieEntity zombie;
        float amount = ev.getAmount();
        if (ev.getEntityLiving() instanceof PVZZombieEntity && (zombie = (PVZZombieEntity)ev.getEntityLiving()).hasDirectDefence() && zombie.getDefenceLife() > 0.0f) {
            if (zombie.getDefenceLife() > amount) {
                zombie.setDefenceLife(zombie.getDefenceLife() - amount);
                amount = 0.0f;
            } else {
                amount -= zombie.getDefenceLife();
                zombie.setDefenceLife(0.0f);
            }
        }
        ev.setAmount(amount == 0.0f ? 1.0E-6f : amount);
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return 9 - worldIn.func_226658_a_(LightType.BLOCK, pos);
    }

    public void func_213295_a(BlockState p_213295_1_, Vector3d p_213295_2_) {
        this.field_70143_R = 0.0f;
        this.field_213328_B = Vector3d.field_186680_a;
    }

    protected float func_225515_ai_() {
        Block block = this.field_70170_p.func_180495_p(this.func_233580_cy_()).func_177230_c();
        float f = block.func_226891_m_();
        if (block == Blocks.field_150355_j || block == Blocks.field_203203_C) {
            return f;
        }
        return 1.0f;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.getOwnerUUID().isPresent();
    }

    protected PVZDamageSource getZombieAttackDamageSource() {
        return PVZDamageSource.eat((Entity)this);
    }

    protected float getModifyAttackDamage(Entity entity, float f) {
        return f;
    }

    @Override
    public Ranks getZombieRank() {
        return ZombieUtil.getZombieRank(this.getZombieEnumName());
    }

    @Override
    public int getZombieXp() {
        return ZombieUtil.getZombieXp(this.getZombieEnumName());
    }

    public void func_70108_f(Entity entityIn) {
        double d1;
        double d0;
        double d2;
        if (this.func_70608_bn()) {
            return;
        }
        if (!this.func_184223_x(entityIn) && !entityIn.field_70145_X && !this.field_70145_X && (d2 = MathHelper.func_76132_a((double)(d0 = entityIn.func_226277_ct_() - this.func_226277_ct_()), (double)(d1 = entityIn.func_226281_cx_() - this.func_226281_cx_()))) >= (double)0.01f) {
            d2 = MathHelper.func_76133_a((double)d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            d0 *= (double)(1.0f - this.field_70144_Y);
            d1 *= (double)(1.0f - this.field_70144_Y);
            if (!this.func_184207_aI()) {
                this.func_70024_g(-d0, 0.0, -d1);
            }
            if (!entityIn.func_184207_aI() && this.checkCanPushEntity(entityIn)) {
                entityIn.func_70024_g(d0, 0.0, d1);
            }
        }
    }

    protected void func_85033_bc() {
        double dd = this.getCollideWidthOffset();
        List list = this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(dd, 0.0, dd));
        if (!list.isEmpty()) {
            int i = this.field_70170_p.func_82736_K().func_223592_c(GameRules.field_223616_s);
            if (i > 0 && list.size() > i - 1 && this.field_70146_Z.nextInt(4) == 0) {
                int j = 0;
                for (int k = 0; k < list.size(); ++k) {
                    if (((Entity)list.get(k)).func_184218_aH()) continue;
                    ++j;
                }
                if (j > i - 1) {
                    this.func_70097_a(DamageSource.field_191291_g, 6.0f);
                }
            }
            for (int l = 0; l < list.size(); ++l) {
                LivingEntity target = (LivingEntity)list.get(l);
                if (this.func_70028_i((Entity)target) || !this.shouldCollideWithEntity(target)) continue;
                this.func_82167_n((Entity)target);
            }
        }
    }

    protected double getCollideWidthOffset() {
        return -0.25;
    }

    protected boolean shouldCollideWithEntity(LivingEntity target) {
        if (this.func_70638_az() == target) {
            return !(target instanceof SquashEntity) && !(target instanceof SpikeWeedEntity);
        }
        if (target instanceof PVZZombieEntity) {
            return this.canCollideWithZombie && ((PVZZombieEntity)target).canCollideWithZombie;
        }
        return false;
    }

    protected boolean checkCanPushEntity(Entity target) {
        return !(target instanceof PVZPlantEntity);
    }

    protected float func_189749_co() {
        return 0.85f;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean canZombieNormalUpdate() {
        if (!EntityUtil.isEntityValid((Entity)this)) {
            return false;
        }
        if (this.needRising && this.getAnimTime() < 0) {
            return false;
        }
        if (this.func_184187_bx() instanceof BungeeZombieEntity) {
            return false;
        }
        return !EntityUtil.isEntityFrozen((LivingEntity)this) && !EntityUtil.isEntityButter((LivingEntity)this);
    }

    public boolean func_184652_a(PlayerEntity player) {
        return !EntityUtil.checkCanEntityBeAttack((Entity)this, (Entity)player);
    }

    @Override
    public boolean canBeAttractedBy(ICanAttract defender) {
        return true;
    }

    @Override
    public void attractBy(ICanAttract defender) {
    }

    public boolean checkCanLostHand() {
        return this.func_110143_aJ() < Math.min(40.0f, this.func_110138_aP() * 0.5f);
    }

    public boolean checkCanLostHead() {
        return this.func_110143_aJ() < 10.0f && this.func_110143_aJ() / this.func_110138_aP() < 0.1f;
    }

    public void checkAndAddPotionEffect(EffectInstance effect) {
        if (effect.func_188419_a() == EffectRegister.COLD_EFFECT.get() && !this.canBeCold()) {
            return;
        }
        if (effect.func_188419_a() == EffectRegister.FROZEN_EFFECT.get() && !this.canBeFrozen()) {
            return;
        }
        if (effect.func_188419_a() == EffectRegister.BUTTER_EFFECT.get() && !this.canBeButter()) {
            return;
        }
        this.func_195064_c(effect);
    }

    @Override
    public void onCharmedBy(LivingEntity entity) {
        if (!this.canBeCharmed()) {
            return;
        }
        PlayerEntity player = EntityUtil.getEntityOwner(this.field_70170_p, (Entity)entity);
        if (player != null && player instanceof ServerPlayerEntity) {
            CharmZombieTrigger.INSTANCE.trigger((ServerPlayerEntity)player, (Entity)this);
        }
        this.setCharmed(!this.isCharmed());
        if (this.getZombieType() == Type.SUPER) {
            this.setZombieType(Type.NORMAL);
            this.dropEnergy();
        }
    }

    public void healZombie(float health) {
        float need1 = this.func_110138_aP() - this.func_110143_aJ();
        this.func_70691_i(Math.min(need1, health));
        this.setDefenceLife(Math.max(this.getExtraLife(), this.getDefenceLife() + (health -= need1)));
    }

    public boolean func_180431_b(DamageSource source) {
        if (source instanceof PVZDamageSource && ((PVZDamageSource)source).isMustHurt()) {
            return false;
        }
        return source != DamageSource.field_76380_i && !source.func_180136_u() && this.isZombieInvulnerableTo(source);
    }

    protected boolean isZombieInvulnerableTo(DamageSource source) {
        return this.isZombieRising() || !EntityUtil.isEntityValid(source.func_76346_g()) && !source.func_82725_o();
    }

    public boolean isZombieRising() {
        return this.getAnimTime() < 0;
    }

    public void setZombieRising() {
        this.needRising = true;
    }

    public void setImmuneAllEffects() {
        this.canBeButter = false;
        this.canBeCold = false;
        this.canBeFrozen = false;
    }

    public void setIsWholeBody() {
        this.canLostHand = false;
        this.canLostHead = false;
    }

    @Override
    public boolean canBeButter() {
        return this.canBeButter;
    }

    @Override
    public boolean canBeCharmed() {
        return this.canBeCharm;
    }

    @Override
    public boolean canBeFrozen() {
        return this.canBeFrozen && !this.func_203005_aq() && !this.func_180799_ab();
    }

    @Override
    public boolean canBeMini() {
        return this.canBeMini;
    }

    @Override
    public boolean canBeInvis() {
        return this.canBeInvis;
    }

    @Override
    public boolean canBeCold() {
        return this.canBeCold;
    }

    @Override
    public boolean canBeStealByBungee() {
        return this.canBeStealByBungee;
    }

    public boolean canLostHand() {
        return this.canLostHand;
    }

    public boolean canLostHead() {
        return this.canLostHead;
    }

    public boolean hasDirectDefence() {
        return this.hasDirectDefence;
    }

    public boolean isZombieColdOrForzen() {
        return EntityUtil.isEntityCold((LivingEntity)this) || EntityUtil.isEntityFrozen((LivingEntity)this);
    }

    @Override
    public float getExtraLife() {
        return 0.0f;
    }

    @Override
    public float getCurrentHealth() {
        return this.getDefenceLife() + this.func_110143_aJ();
    }

    @Override
    public float getCurrentMaxHealth() {
        return this.getDefenceLife() + this.func_110138_aP();
    }

    @Override
    public PVZGroupType getEntityGroupType() {
        return this.isCharmed() ? PVZGroupType.PLANTS : PVZGroupType.ZOMBIES;
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)SoundRegister.ZOMBIE_SAY.get();
    }

    public SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        if (damageSourceIn.func_76364_f() instanceof AbstractBulletEntity) {
            return (SoundEvent)SoundRegister.PEA_HIT.get();
        }
        return super.func_184601_bQ(damageSourceIn);
    }

    protected Optional<SoundEvent> getSpawnSound() {
        if (this.needRising) {
            return Optional.ofNullable(SoundRegister.DIRT_RISE.get());
        }
        return Optional.empty();
    }

    protected ResourceLocation func_184647_J() {
        return PVZLoot.NORMAL_ZOMBIE;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("zombie_type", this.getZombieType().ordinal());
        if (this.getOwnerUUID().isPresent()) {
            compound.func_186854_a("OwnerUUID", this.getOwnerUUID().get());
        }
        compound.func_74768_a("zombie_states_flag", this.getZombieStates());
        compound.func_74768_a("zombie_attack_time", this.getAttackTime());
        compound.func_74768_a("zombie_anim_time", this.getAnimTime());
        compound.func_74776_a("defence_life", this.getDefenceLife());
        compound.func_74768_a("zombie_level", this.getZombieLevel());
        compound.func_74768_a("exist_tick", this.field_70173_aa);
    }

    public void func_70037_a(CompoundNBT compound) {
        UUID uuid;
        super.func_70037_a(compound);
        if (compound.func_74764_b("zombie_type")) {
            this.setZombieType(Type.values()[compound.func_74762_e("zombie_type")]);
        }
        if (compound.func_186855_b("OwnerUUID")) {
            uuid = compound.func_186857_a("OwnerUUID");
        } else {
            String s1 = compound.func_74779_i("OwnerUUID");
            uuid = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (compound.func_74764_b("zombie_states_flag")) {
            this.setZombieStates(compound.func_74762_e("zombie_states_flag"));
        }
        if (compound.func_74764_b("zombie_attack_time")) {
            this.setAttackTime(compound.func_74762_e("zombie_attack_time"));
        }
        if (compound.func_74764_b("zombie_anim_time")) {
            this.setAnimTime(compound.func_74762_e("zombie_anim_time"));
        }
        if (compound.func_74764_b("defence_life")) {
            this.setDefenceLife(compound.func_74760_g("defence_life"));
        }
        if (compound.func_74764_b("zombie_level")) {
            this.setZombieLevel(compound.func_74762_e("zombie_level"));
        }
        this.field_70173_aa = compound.func_74762_e("exist_tick");
    }

    public int getZombieLevel() {
        return (Integer)this.field_70180_af.func_187225_a(ZOMBIE_LEVEL);
    }

    public void setZombieLevel(int level) {
        this.field_70180_af.func_187227_b(ZOMBIE_LEVEL, (Object)level);
    }

    public int getAttackTime() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACK_TIME);
    }

    public void setAttackTime(int cd) {
        this.field_70180_af.func_187227_b(ATTACK_TIME, (Object)cd);
    }

    public int getAnimTime() {
        return (Integer)this.field_70180_af.func_187225_a(ANIM_TIME);
    }

    public void setAnimTime(int cd) {
        this.field_70180_af.func_187227_b(ANIM_TIME, (Object)cd);
    }

    public int getZombieStates() {
        return (Integer)this.field_70180_af.func_187225_a(ZOMBIE_STATES);
    }

    public void setZombieStates(int state) {
        this.field_70180_af.func_187227_b(ZOMBIE_STATES, (Object)state);
    }

    public float getDefenceLife() {
        return ((Float)this.field_70180_af.func_187225_a(DEFENCE_LIFE)).floatValue();
    }

    public void setDefenceLife(float life) {
        this.field_70180_af.func_187227_b(DEFENCE_LIFE, (Object)Float.valueOf(life));
    }

    @Override
    public Optional<UUID> getOwnerUUID() {
        return (Optional)this.field_70180_af.func_187225_a(OWNER_UUID);
    }

    public void setOwnerUUID(UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER_UUID, Optional.ofNullable(uuid));
    }

    public Type getZombieType() {
        return Type.values()[(Integer)this.field_70180_af.func_187225_a(ZOMBIE_TYPE)];
    }

    public void setZombieType(Type type) {
        this.field_70180_af.func_187227_b(ZOMBIE_TYPE, (Object)type.ordinal());
    }

    @Override
    public boolean isCharmed() {
        return AlgorithmUtil.BitOperator.hasBitOne(this.getZombieStates(), 0);
    }

    public void setCharmed(boolean is) {
        this.setStateByFlag(is, 0);
    }

    public boolean isMiniZombie() {
        return AlgorithmUtil.BitOperator.hasBitOne(this.getZombieStates(), 1);
    }

    public void setMiniZombie(boolean is) {
        this.setStateByFlag(is, 1);
    }

    public boolean hasHand() {
        return !AlgorithmUtil.BitOperator.hasBitOne(this.getZombieStates(), 2);
    }

    public void lostHand(boolean is) {
        this.setStateByFlag(is, 2);
    }

    public boolean hasHead() {
        return !AlgorithmUtil.BitOperator.hasBitOne(this.getZombieStates(), 3);
    }

    public void lostHead(boolean is) {
        this.setStateByFlag(is, 3);
    }

    private void setStateByFlag(boolean is, int flag) {
        this.setZombieStates(AlgorithmUtil.BitOperator.setBit(this.getZombieStates(), flag, is));
    }

    protected static enum DropType {
        COPPER,
        SILVER,
        GOLD,
        JEWEL,
        CHOCOLATE;

    }

    public static enum Type {
        NORMAL,
        SUPER,
        BEARD,
        SUN;

    }
}

