/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.zombie.base;

import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.ZombieUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;

public abstract class AbstractBossZombieEntity
extends PVZZombieEntity {
    protected final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS).func_186741_a(true);
    protected int refreshCountCD = 30;
    protected int spawnImmuneCD = 100;
    protected float kickRange = 0.0f;
    protected int maxZombieSurround = 40;
    protected int maxPlantSurround = 50;
    protected int nearbyPlantCount = 0;
    protected int nearbyZombieCount = 0;
    private int noTargetTick = 0;

    public AbstractBossZombieEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.canCollideWithZombie = false;
        this.setImmuneAllEffects();
        this.canBeMini = false;
        this.canBeInvis = false;
        this.canBeStealByBungee = false;
        this.canBeRemove = false;
    }

    @Override
    protected PVZZombieEntity.Type getSpawnType() {
        return PVZZombieEntity.Type.NORMAL;
    }

    @Override
    public void zombieTick() {
        super.zombieTick();
        float percent = (this.getDefenceLife() + this.func_110143_aJ()) / (this.func_110138_aP() + this.getExtraLife());
        this.bossInfo.func_186735_a(percent);
        if (!this.field_70170_p.field_72995_K) {
            this.checkAndHeal(percent);
            if (this.field_70173_aa % this.refreshCountCD == 0) {
                this.nearbyPlantCount = this.getNearbyPlantCount();
                this.nearbyZombieCount = this.getNearbyPlantCount();
                if (this.isCharmed()) {
                    this.setZombieLevel(MathHelper.func_76125_a((int)((this.nearbyZombieCount - 15) / 5), (int)1, (int)20));
                } else {
                    this.setZombieLevel(MathHelper.func_76125_a((int)((this.nearbyPlantCount - 15) / 5), (int)1, (int)20));
                }
            }
            this.kickEnemiesNearby();
        }
    }

    public void kickEnemiesNearby() {
        if (this.field_70173_aa % 10 == 0 && this.kickRange > 0.0f) {
            this.field_70170_p.func_175647_a(LivingEntity.class, EntityUtil.getEntityAABB((Entity)this, this.kickRange, this.func_213302_cg() + 1.0f), target -> EntityUtil.canAttackEntity((Entity)target, (Entity)this)).forEach(target -> {
                if (target instanceof PVZPlantEntity) {
                    target.func_70606_j(0.0f);
                } else {
                    target.func_70097_a((DamageSource)PVZDamageSource.normal((Entity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e());
                    target.func_213317_d(target.func_213303_ch().func_72441_c(0.0, (double)target.func_70047_e(), 0.0).func_178788_d(this.func_213303_ch()).func_72432_b().func_186678_a(2.0));
                }
            });
        }
    }

    public void checkAndHeal(float percent) {
        if (this.func_70638_az() == null && ++this.noTargetTick >= 40) {
            this.func_70691_i(1.0f);
        }
    }

    @Override
    protected boolean isZombieInvulnerableTo(DamageSource source) {
        return super.isZombieInvulnerableTo(source) || this.field_70173_aa <= this.spawnImmuneCD;
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    @Override
    protected boolean shouldCollideWithEntity(LivingEntity target) {
        return EntityUtil.canTargetEntity((Entity)this, (Entity)target);
    }

    protected void func_82167_n(Entity entityIn) {
        super.func_82167_n(entityIn);
        if (!this.field_70170_p.field_72995_K && entityIn instanceof LivingEntity && EntityUtil.canTargetEntity((Entity)this, entityIn) && this.field_70173_aa % 5 == 0) {
            entityIn.func_70097_a((DamageSource)PVZDamageSource.causeCrushDamage((Entity)this), EntityUtil.getMaxHealthDamage((LivingEntity)entityIn, 0.5f));
        }
    }

    public void onBossSummon(PVZZombieEntity zombie, BlockPos pos) {
        ZombieUtil.copySummonZombieData(this, zombie);
        EntityUtil.onEntitySpawn((IWorld)this.field_70170_p, (Entity)zombie, pos);
        zombie.setZombieLevel(this.getZombieLevel());
    }

    protected int getNearbyPlantCount() {
        float range = 50.0f;
        return this.field_70170_p.func_175647_a(PVZPlantEntity.class, EntityUtil.getEntityAABB((Entity)this, 50.0, 50.0), plant -> EntityUtil.canTargetEntity((Entity)this, (Entity)plant)).size();
    }

    protected int getNearbyZombieCount() {
        float range = 30.0f;
        return this.field_70170_p.func_175647_a(PVZZombieEntity.class, EntityUtil.getEntityAABB((Entity)this, 30.0, 30.0), plant -> !EntityUtil.canTargetEntity((Entity)this, (Entity)plant)).size();
    }

    @Override
    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return null;
    }
}

