/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.zombie.base;

import com.hungteen.pvz.common.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.common.entity.zombie.body.ZombieDropBodyEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public abstract class CarZombieEntity
extends PVZZombieEntity {
    public CarZombieEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.setIsWholeBody();
        this.canBeFrozen = false;
        this.canBeMini = false;
        this.maxDeathTime = 1;
    }

    @Override
    public void zombieTick() {
        super.zombieTick();
        if (this.field_70170_p.field_72995_K && this.isCarShaking()) {
            for (int i = 1; i <= 3; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), ((double)this.func_70681_au().nextFloat() - 0.5) / 10.0, 0.05, ((double)this.func_70681_au().nextFloat() - 0.5) / 10.0);
            }
        }
    }

    @Override
    protected void onZombieRemove() {
        if (!this.field_70170_p.field_72995_K) {
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.CAR_EXPLOSION.get());
        } else {
            for (int i = 0; i < 4; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        }
        super.onZombieRemove();
    }

    @Override
    protected void onFallBody(DamageSource source) {
        ZombieDropBodyEntity body = (ZombieDropBodyEntity)((EntityType)EntityRegister.ZOMBIE_DROP_BODY.get()).func_200721_a(this.field_70170_p);
        body.specialDropBody(this, source, ZombieDropBodyEntity.BodyType.HEAD);
        this.setBodyStates(body);
        this.field_70170_p.func_217376_c((Entity)body);
    }

    public boolean isCarShaking() {
        return this.func_110143_aJ() <= this.func_110138_aP() / 4.0f;
    }

    @Override
    public boolean canBreakPlantBlock() {
        return false;
    }

    @Override
    protected PVZDamageSource getZombieAttackDamageSource() {
        return PVZDamageSource.causeCrushDamage((Entity)this);
    }

    @Override
    protected float getModifyAttackDamage(Entity entity, float f) {
        if (entity instanceof LivingEntity) {
            return EntityUtil.getMaxHealthDamage((LivingEntity)entity);
        }
        return f;
    }
}

