/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.zombie.base;

import com.hungteen.pvz.common.entity.PVZMultiPartEntity;
import com.hungteen.pvz.common.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.common.entity.zombie.part.PVZHealthPartEntity;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.interfaces.IMultiPartZombie;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public abstract class DefenceZombieEntity
extends PVZZombieEntity
implements IMultiPartZombie {
    protected PVZHealthPartEntity part;

    public DefenceZombieEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.resetParts();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.updateParts();
        }
    }

    @Override
    public void removeParts() {
        if (EntityUtil.isEntityValid(this.part)) {
            this.part.func_70106_y();
            this.part = null;
        }
    }

    @Override
    public void updateParts() {
        if (this.canPartsExist()) {
            if (!EntityUtil.isEntityValid(this.part)) {
                this.resetParts();
            }
            if (!this.part.isAddedToWorld()) {
                this.field_70170_p.func_217376_c((Entity)this.part);
            }
            float j = 6.28318f * this.field_70177_z / 360.0f;
            float dis = this.getPartWidthOffset();
            Vector3d pos = this.func_213303_ch();
            this.part.field_70126_B = this.field_70177_z;
            this.part.field_70127_C = this.field_70125_A;
            this.part.func_70012_b(pos.func_82615_a() - Math.sin(j) * (double)dis, pos.func_82617_b() + (double)this.getPartHeightOffset(), pos.func_82616_c() + Math.cos(j) * (double)dis, this.field_70177_z, this.field_70125_A);
            this.part.setOwner((LivingEntity)this);
        } else {
            this.removeParts();
        }
    }

    @Override
    public void onZombieBeMini() {
        super.onZombieBeMini();
        if (EntityUtil.isEntityValid(this.part)) {
            this.part.onOwnerBeMini(this);
        }
        this.setDefenceLife(this.getPartLife() * 0.6f);
    }

    @Override
    public PVZMultiPartEntity[] getMultiParts() {
        return new PVZMultiPartEntity[]{this.part};
    }

    @Override
    public boolean canPartsExist() {
        return this.getDefenceLife() > 0.0f;
    }

    public abstract float getPartLife();

    @Override
    public float getExtraLife() {
        return this.getPartLife();
    }

    protected float getPartHeightOffset() {
        if (this.isMiniZombie()) {
            return 0.1f;
        }
        return 0.2f;
    }

    public float getPartWidthOffset() {
        if (this.isMiniZombie()) {
            return 0.3f;
        }
        return 0.55f;
    }

    public SoundEvent getPartHurtSound() {
        return null;
    }

    public SoundEvent getPartDeathSound() {
        return null;
    }
}

