/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.zombie.body;

import com.hungteen.pvz.common.entity.PVZEntityBase;
import com.hungteen.pvz.common.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.utils.AlgorithmUtil;
import com.hungteen.pvz.utils.enums.Zombies;
import java.util.Optional;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ZombieDropBodyEntity
extends PVZEntityBase {
    private static final DataParameter<Integer> ZOMBIE_TYPE = EntityDataManager.func_187226_a(ZombieDropBodyEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> BODY_TYPE = EntityDataManager.func_187226_a(ZombieDropBodyEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> BODY_STATE = EntityDataManager.func_187226_a(ZombieDropBodyEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ANIM_TIME = EntityDataManager.func_187226_a(ZombieDropBodyEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final int MAX_EXIST_TICK = 60;
    private static final int HAS_HAND_DEFENCE = 0;
    private static final int MINI_BODY = 1;
    public final int HEAD_ROT = this.field_70146_Z.nextInt(60) - 30;
    private int max_exist_tick = 60;
    private float friction = 0.3f;

    public ZombieDropBodyEntity(EntityType<?> p_i48580_1_, World p_i48580_2_) {
        super(p_i48580_1_, p_i48580_2_);
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ZOMBIE_TYPE, (Object)Zombies.NORMAL_ZOMBIE.ordinal());
        this.field_70180_af.func_187214_a(BODY_TYPE, (Object)BodyType.HAND.ordinal());
        this.field_70180_af.func_187214_a(BODY_STATE, (Object)0);
        this.field_70180_af.func_187214_a(ANIM_TIME, (Object)0);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.tickMove();
        if (!this.field_70170_p.field_72995_K) {
            if (this.getAnimTime() >= this.max_exist_tick) {
                this.func_70106_y();
            } else {
                this.setAnimTime(this.getAnimTime() + 1);
            }
        }
        if (this.field_70122_E) {
            this.func_213317_d(this.func_213322_ci().func_186678_a((double)this.friction));
        }
    }

    public void droppedByOwner(PVZZombieEntity zombie, DamageSource source, BodyType type) {
        this.updateInfo(zombie, type);
        switch (type) {
            case HAND: {
                float j = 6.28318f * this.field_70177_z / 360.0f;
                float dis = 0.6f;
                this.func_70107_b(zombie.func_213303_ch().field_72450_a - Math.sin(j) * (double)0.6f, zombie.func_213303_ch().field_72448_b + (double)zombie.func_70047_e(), zombie.func_213303_ch().field_72449_c + Math.cos(j) * (double)0.6f);
                break;
            }
            case HEAD: {
                this.hitUp(zombie, source, 0.3);
                break;
            }
            case BODY: {
                this.func_70107_b(zombie.func_213303_ch().field_72450_a, zombie.func_213303_ch().field_72448_b, zombie.func_213303_ch().field_72449_c);
                this.func_213317_d(zombie.func_213322_ci());
                break;
            }
        }
    }

    public void specialDropBody(PVZZombieEntity zombie, DamageSource source, BodyType type) {
        this.updateInfo(zombie, type);
        switch (zombie.getZombieEnumName()) {
            case ZOMBONI: 
            case CATAPULT_ZOMBIE: {
                this.hitUp(zombie, source, 0.5, 0.5, 0.5);
                break;
            }
        }
    }

    private void hitUp(PVZZombieEntity zombie, DamageSource source, double speed) {
        this.hitUp(zombie, source, speed, speed, speed);
    }

    private void hitUp(PVZZombieEntity zombie, DamageSource source, double speed, double speedH, double speedV) {
        this.func_70107_b(zombie.func_213303_ch().field_72450_a, zombie.func_213303_ch().field_72448_b + (double)zombie.func_70047_e(), zombie.func_213303_ch().field_72449_c);
        double speedX = (this.field_70146_Z.nextDouble() - 0.5) * speedH;
        double speedZ = (this.field_70146_Z.nextDouble() - 0.5) * speedH;
        double speedY = this.field_70146_Z.nextDouble() * speedV;
        Optional.ofNullable(source.func_188404_v()).ifPresent(vec -> {
            Vector3d v = this.func_213303_ch().func_178788_d(vec);
            this.func_213317_d(v.func_72432_b().func_216372_d(speed, speed, speed).func_72441_c(speedX, speedY, speedZ));
        });
    }

    public void updateInfo(PVZZombieEntity zombie, BodyType type) {
        this.setZombieType(zombie.getZombieEnumName());
        this.setMini(zombie.isMiniZombie());
        this.setBodyType(type);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double p_70016_1_, double p_70016_3_, double p_70016_5_) {
        this.func_213293_j(p_70016_1_, p_70016_3_, p_70016_5_);
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(p_70016_1_ * p_70016_1_ + p_70016_5_ * p_70016_5_));
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)p_70016_3_, (double)f) * 57.2957763671875);
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)p_70016_1_, (double)p_70016_5_) * 57.2957763671875);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
        }
    }

    public EntitySize func_213305_a(Pose p_213305_1_) {
        return EntitySize.func_220314_b((float)0.5f, (float)0.5f);
    }

    public void setMaxLiveTick(int tick) {
        this.max_exist_tick = tick;
    }

    public void setFriction(float f) {
        this.friction = f;
    }

    @Override
    protected void func_70037_a(CompoundNBT nbt) {
        if (nbt.func_74764_b("body_anim_tick")) {
            this.setAnimTime(nbt.func_74762_e("body_anim_tick"));
        }
        if (nbt.func_74764_b("body_zombie_type")) {
            this.setZombieType(Zombies.values()[nbt.func_74762_e("body_zombie_type")]);
        }
        if (nbt.func_74764_b("body_part_state")) {
            this.setBodyState(nbt.func_74762_e("body_part_state"));
        }
        if (nbt.func_74764_b("body_part_type")) {
            this.setBodyType(BodyType.values()[nbt.func_74762_e("body_part_type")]);
        }
    }

    @Override
    protected void func_213281_b(CompoundNBT nbt) {
        nbt.func_74768_a("body_anim_tick", this.getAnimTime());
        nbt.func_74768_a("body_zombie_type", this.getZombieType().ordinal());
        nbt.func_74768_a("body_part_state", this.getBodyState());
        nbt.func_74768_a("body_part_type", this.getBodyType().ordinal());
    }

    public Zombies getZombieType() {
        return Zombies.values()[(Integer)this.field_70180_af.func_187225_a(ZOMBIE_TYPE)];
    }

    public void setZombieType(Zombies type) {
        this.field_70180_af.func_187227_b(ZOMBIE_TYPE, (Object)type.ordinal());
    }

    public BodyType getBodyType() {
        return BodyType.values()[(Integer)this.field_70180_af.func_187225_a(BODY_TYPE)];
    }

    public void setBodyType(BodyType type) {
        this.field_70180_af.func_187227_b(BODY_TYPE, (Object)type.ordinal());
    }

    public int getBodyState() {
        return (Integer)this.field_70180_af.func_187225_a(BODY_STATE);
    }

    public void setBodyState(int state) {
        this.field_70180_af.func_187227_b(BODY_STATE, (Object)state);
    }

    public int getAnimTime() {
        return (Integer)this.field_70180_af.func_187225_a(ANIM_TIME);
    }

    public void setAnimTime(int tick) {
        this.field_70180_af.func_187227_b(ANIM_TIME, (Object)tick);
    }

    public void setHandDefence(boolean flag) {
        this.setBodyState(AlgorithmUtil.BitOperator.setBit(this.getBodyState(), 0, flag));
    }

    public boolean hasHandDefence() {
        return AlgorithmUtil.BitOperator.hasBitOne(this.getBodyState(), 0);
    }

    public void setMini(boolean flag) {
        this.setBodyState(AlgorithmUtil.BitOperator.setBit(this.getBodyState(), 1, flag));
    }

    public boolean isMini() {
        return AlgorithmUtil.BitOperator.hasBitOne(this.getBodyState(), 1);
    }

    public static enum BodyType {
        HAND,
        HEAD,
        BODY,
        LEFT_HAND,
        RIGHT_HAND,
        LEFT_LEG,
        RIGHT_LEG;

    }
}

