/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.zombie.grassday;

import com.hungteen.pvz.api.interfaces.IPVZPlant;
import com.hungteen.pvz.common.entity.ai.goal.target.PVZRandomTargetGoal;
import com.hungteen.pvz.common.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.common.entity.zombie.body.ZombieDropBodyEntity;
import com.hungteen.pvz.common.entity.zombie.poolnight.DiggerZombieEntity;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.MathUtil;
import com.hungteen.pvz.utils.enums.Plants;
import com.hungteen.pvz.utils.enums.Zombies;
import com.hungteen.pvz.utils.interfaces.ICanAttract;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class PoleZombieEntity
extends PVZZombieEntity {
    private static final DataParameter<Boolean> HAS_POLE = EntityDataManager.func_187226_a(DiggerZombieEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected final float HorizontalJumpSpeed = 1.5f;
    protected final float VerticalJumpSpeed = 0.7f;
    protected Vector3d jumpDstPoint = Vector3d.field_186680_a;
    protected int pole_jump_cnt;

    public PoleZombieEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_POLE, (Object)true);
    }

    @Override
    protected void registerAttackGoals() {
        super.registerAttackGoals();
        this.field_70714_bg.func_75776_a(0, (Goal)new PoleJumpGoal(this));
    }

    @Override
    protected void registerTargetGoals() {
        this.field_70715_bh.func_75776_a(0, (Goal)new PVZRandomTargetGoal((MobEntity)this, true, true, 60.0f, 20.0f));
    }

    @Override
    protected void updateAttributes() {
        super.updateAttributes();
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.25);
    }

    public void func_184206_a(DataParameter<?> data) {
        super.func_184206_a(data);
        if (data.equals(HAS_POLE)) {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(this.hasPole() ? 0.25 : (double)0.2f);
        }
    }

    @Override
    public boolean canBeAttractedBy(ICanAttract defender) {
        if (defender instanceof IPVZPlant) {
            Plants plant = ((IPVZPlant)((Object)defender)).getPlantEnumName();
            return plant == Plants.TALL_NUT || plant == Plants.GIANT_WALL_NUT;
        }
        return true;
    }

    @Override
    public void attractBy(ICanAttract defender) {
        super.attractBy(defender);
        if (this.hasPole()) {
            this.setPole(false);
            this.func_213293_j(0.0, 0.0, 0.0);
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.WALL_HIT.get());
        }
    }

    @Override
    public boolean canBeTargetBy(LivingEntity living) {
        return super.canBeTargetBy(living) && !this.isPoleJumping();
    }

    @Override
    protected boolean isZombieInvulnerableTo(DamageSource source) {
        return super.isZombieInvulnerableTo(source) || this.isPoleJumping();
    }

    @Override
    protected void setBodyStates(ZombieDropBodyEntity body) {
        super.setBodyStates(body);
        body.setHandDefence(this.hasPole());
    }

    public void perfromJump() {
        Optional.ofNullable(this.func_70638_az()).ifPresent(target -> {
            Vector3d vec = MathUtil.getHorizontalNormalizedVec(this.func_213303_ch(), this.jumpDstPoint);
            this.getClass();
            double speedXZ = 1.5 + (this.field_70146_Z.nextDouble() - 0.3) / 2.0;
            this.getClass();
            double speedY = (double)0.7f + (this.field_70146_Z.nextDouble() - 0.3) / 2.0;
            this.func_213293_j(vec.field_72450_a * speedXZ, speedY, vec.field_72449_c * speedXZ);
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.POLE_JUMP.get());
        });
    }

    public int getMaxJumpCount() {
        return this.getZombieLevel();
    }

    @Override
    public float getLife() {
        return 50.0f;
    }

    public int getPoleJumpCD() {
        return 20;
    }

    public boolean isPoleJumping() {
        return this.getAttackTime() > 0;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("zombie_has_pole")) {
            this.setPole(compound.func_74767_n("zombie_has_pole"));
        }
        if (compound.func_74764_b("jump_dst_point")) {
            CompoundNBT nbt = compound.func_74775_l("jump_dst_point");
            this.jumpDstPoint = new Vector3d(nbt.func_74769_h("XXX"), nbt.func_74769_h("YYY"), nbt.func_74769_h("ZZZ"));
        }
        if (compound.func_74764_b("pole_jump_count")) {
            this.pole_jump_cnt = compound.func_74762_e("pole_jump_count");
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("zombie_has_pole", this.hasPole());
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74780_a("XXX", this.jumpDstPoint.field_72450_a);
        nbt.func_74780_a("YYY", this.jumpDstPoint.field_72448_b);
        nbt.func_74780_a("ZZZ", this.jumpDstPoint.field_72449_c);
        compound.func_218657_a("jump_dst_point", (INBT)nbt);
        compound.func_74768_a("pole_jump_count", this.pole_jump_cnt);
    }

    public void setPole(boolean has) {
        this.field_70180_af.func_187227_b(HAS_POLE, (Object)has);
    }

    public boolean hasPole() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_POLE);
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.POLE_ZOMBIE;
    }

    static class PoleJumpGoal
    extends Goal {
        private final PoleZombieEntity zombie;
        private int delayCnt = 0;

        public PoleJumpGoal(PoleZombieEntity zombie) {
            this.zombie = zombie;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            if (this.zombie.getAttackTime() > 0) {
                return true;
            }
            if (this.delayCnt > 0) {
                --this.delayCnt;
                return false;
            }
            LivingEntity target = this.zombie.func_70638_az();
            int left_jump_chance = this.zombie.getMaxJumpCount() - this.zombie.pole_jump_cnt;
            if (!EntityUtil.isEntityValid((Entity)target) || !this.zombie.func_233570_aj_() || left_jump_chance <= 0) {
                return false;
            }
            double dis = this.zombie.func_70068_e((Entity)target);
            if (dis < 64.0 || dis > (double)Math.max(100, 100 * left_jump_chance * left_jump_chance)) {
                return false;
            }
            Vector3d vector3d = MathUtil.getHorizontalNormalizedVec(this.zombie.func_213303_ch(), target.func_213303_ch());
            this.zombie.getClass();
            Vector3d vec = vector3d.func_186678_a(1.5).func_72441_c(0.0, (double)(this.zombie.VerticalJumpSpeed * 2.0f), 0.0);
            if (!EntityUtil.canEntityPass((Entity)this.zombie, vec, 10.0f)) {
                this.delayCnt = this.zombie.field_70146_Z.nextInt(50);
                return false;
            }
            this.zombie.jumpDstPoint = target.func_213303_ch();
            this.zombie.func_70624_b(target);
            return true;
        }

        public void func_75249_e() {
            this.zombie.setAttackTime(this.zombie.getPoleJumpCD());
            this.zombie.func_213395_q(false);
        }

        public boolean func_75253_b() {
            return this.zombie.getAttackTime() > 0;
        }

        public void func_75246_d() {
            int time = this.zombie.getAttackTime();
            int cd = this.zombie.getPoleJumpCD();
            this.zombie.func_70671_ap().func_220674_a(this.zombie.jumpDstPoint);
            if (time == cd * 3 / 4) {
                this.zombie.perfromJump();
            } else if (time == 1 && ++this.zombie.pole_jump_cnt == this.zombie.getMaxJumpCount()) {
                this.zombie.setPole(false);
            }
            this.zombie.setAttackTime(Math.max(0, time - 1));
        }
    }
}

