/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.zombie.grassnight;

import com.hungteen.pvz.common.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.common.entity.zombie.grassnight.DancingZombieEntity;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.MathUtil;
import com.hungteen.pvz.utils.enums.Zombies;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;

public class BackupDancerEntity
extends PVZZombieEntity {
    public static final int DANCE_CD = 100;
    protected Optional<DancingZombieEntity> owner = Optional.empty();
    private static final int MIN_REST_CD = 60;
    private static final int MAX_REST_CD = 300;
    private int restTick = 0;

    public BackupDancerEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.canCollideWithZombie = false;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new ZombieDanceGoal(this));
    }

    @Override
    public void normalZombieTick() {
        super.normalZombieTick();
        if (!this.field_70170_p.field_72995_K) {
            this.updateSpeed();
            if (this.needFollow()) {
                this.owner.ifPresent(dancer -> {
                    this.setAttackTime(dancer.getAttackTime());
                    this.field_70177_z = dancer.field_70177_z;
                    this.field_70125_A = dancer.field_70125_A;
                    this.field_70759_as = dancer.field_70759_as;
                });
            }
        }
    }

    @Override
    public float getLife() {
        return 20.0f;
    }

    public boolean needFollow() {
        return this.owner.isPresent() && EntityUtil.isEntityValid((Entity)this.owner.get());
    }

    public void setDancingOwner(DancingZombieEntity dancer) {
        this.owner = Optional.ofNullable(dancer);
    }

    protected void setRestTick() {
        this.restTick = MathUtil.getRandomMinMax(this.field_70146_Z, 60, 300);
    }

    protected void updateSpeed() {
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(this.getAttackTime() > 0 ? 0.0 : (double)0.19f);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        Entity entity;
        super.func_70037_a(compound);
        if (compound.func_74764_b("zombie_rest_tick")) {
            this.restTick = compound.func_74762_e("zombie_rest_tick");
        }
        if (compound.func_74764_b("dancing_owner") && EntityUtil.isEntityValid(entity = this.field_70170_p.func_73045_a(compound.func_74762_e("dancing_owner"))) && entity instanceof DancingZombieEntity) {
            this.owner = Optional.ofNullable((DancingZombieEntity)entity);
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("zombie_rest_tick", this.restTick);
        this.owner.ifPresent(dancer -> compound.func_74768_a("dancing_owner", dancer.func_145782_y()));
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.BACKUP_DANCER;
    }

    static class ZombieDanceGoal
    extends Goal {
        private final BackupDancerEntity dancer;

        public ZombieDanceGoal(BackupDancerEntity dancer) {
            this.dancer = dancer;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            if (this.dancer.needFollow()) {
                return false;
            }
            if (this.dancer.getAttackTime() > 0) {
                return true;
            }
            if (this.dancer.restTick > 0) {
                --this.dancer.restTick;
                return false;
            }
            if (this.dancer.func_70681_au().nextFloat() < 0.05f) {
                this.dancer.setAttackTime(100);
                return true;
            }
            return false;
        }

        public void func_75249_e() {
            this.dancer.updateSpeed();
        }

        public boolean func_75253_b() {
            return this.dancer.getAttackTime() > 0;
        }

        public void func_75246_d() {
            int tick = this.dancer.getAttackTime();
            if (tick == 1) {
                this.dancer.setRestTick();
            }
            this.dancer.setAttackTime(Math.max(0, tick - 1));
        }

        public void func_75251_c() {
            this.dancer.updateSpeed();
        }
    }
}

