/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.zombie.grassnight;

import com.hungteen.pvz.common.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.common.entity.zombie.grassnight.BackupDancerEntity;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.MathUtil;
import com.hungteen.pvz.utils.WorldUtil;
import com.hungteen.pvz.utils.ZombieUtil;
import com.hungteen.pvz.utils.enums.Zombies;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class DancingZombieEntity
extends PVZZombieEntity {
    private static final DataParameter<Integer> SUMMON_TIME = EntityDataManager.func_187226_a(DancingZombieEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final int MAX_DANCER_NUM = 4;
    private static final float[][] POS_OFFSET = new float[][]{{2.0f, 0.0f}, {-2.0f, 0.0f}, {0.0f, 2.0f}, {0.0f, -2.0f}};
    public static final int SUMMON_CD = 10;
    public static final int DANCE_CD = 100;
    private static final int MIN_REST_CD = 60;
    private static final int MAX_REST_CD = 300;
    private final List<Optional<BackupDancerEntity>> Dancers = new ArrayList<Optional<BackupDancerEntity>>(4);
    private int summonCnt = 0;
    private int restTick = 0;

    public DancingZombieEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.canCollideWithZombie = false;
        this.setRestTick();
        for (int i = 0; i < 4; ++i) {
            this.Dancers.add(Optional.empty());
        }
        this.clearDancers();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SUMMON_TIME, (Object)0);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new ZombieDanceGoal(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new SummonDancerGoal(this));
    }

    public void tickDance() {
        for (int i = 0; i < 4; ++i) {
            this.Dancers.get(i).ifPresent(dancer -> {});
        }
    }

    public void summonEmptyDancers() {
        for (int i = 0; i < 4; ++i) {
            if (this.Dancers.get(i).isPresent() || this.summonCnt >= this.getMaxSummonCnt()) continue;
            BackupDancerEntity dancer = (BackupDancerEntity)((EntityType)EntityRegister.BACKUP_DANCER.get()).func_200721_a(this.field_70170_p);
            BlockPos pos = WorldUtil.getSuitableHeightPos(this.field_70170_p, this.func_233580_cy_().func_177963_a((double)POS_OFFSET[i][0], 0.0, (double)POS_OFFSET[i][1]));
            dancer.setDancingOwner(this);
            dancer.setZombieRising();
            ZombieUtil.copySummonZombieData(this, dancer);
            this.setDancer(i, (Entity)dancer);
            ++this.summonCnt;
            EntityUtil.onEntitySpawn((IWorld)this.field_70170_p, (Entity)dancer, pos);
            this.func_195064_c(new EffectInstance(Effects.field_76421_d, 40, 5, false, false));
        }
    }

    protected void setRestTick() {
        this.restTick = MathUtil.getRandomMinMax(this.field_70146_Z, 60, 300);
    }

    protected void updateSpeed() {
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(this.getAttackTime() > 0 ? 0.0 : (double)0.19f);
    }

    protected boolean hasEmptyPlace() {
        for (int i = 0; i < 4; ++i) {
            if (!this.Dancers.get(i).isPresent()) {
                return true;
            }
            if (EntityUtil.isEntityValid((Entity)this.Dancers.get(i).get())) continue;
            this.Dancers.set(i, Optional.empty());
            return true;
        }
        return false;
    }

    private void clearDancers() {
        for (int i = 0; i < 4; ++i) {
            this.Dancers.set(i, Optional.empty());
        }
    }

    private void setDancer(int pos, Entity entity) {
        if (EntityUtil.isEntityValid(entity) && entity instanceof BackupDancerEntity) {
            this.Dancers.set(pos, Optional.ofNullable((BackupDancerEntity)entity));
        }
    }

    public boolean isDancing() {
        return this.getAttackTime() > 0;
    }

    public int getMaxSummonCnt() {
        return 40;
    }

    @Override
    public float getLife() {
        return 50.0f;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("zombie_summon_tick")) {
            this.setSummonTime(compound.func_74762_e("zombie_summon_tick"));
        }
        if (compound.func_74764_b("zombie_rest_tick")) {
            this.restTick = compound.func_74762_e("zombie_rest_tick");
        }
        if (compound.func_74764_b("dancer_ids")) {
            CompoundNBT nbt = compound.func_74775_l("dancer_ids");
            for (int i = 0; i < 4; ++i) {
                if (!nbt.func_74764_b("dancer_" + i)) continue;
                this.setDancer(i, this.field_70170_p.func_73045_a(nbt.func_74762_e("dancer_" + i)));
            }
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("zombie_summon_tick", this.getSummonTime());
        compound.func_74768_a("zombie_rest_tick", this.restTick);
        CompoundNBT nbt = new CompoundNBT();
        for (int i = 0; i < 4; ++i) {
            BackupDancerEntity dancer;
            if (!this.Dancers.get(i).isPresent() || !EntityUtil.isEntityValid((Entity)(dancer = this.Dancers.get(i).get()))) continue;
            nbt.func_74768_a("dancer_" + i, dancer.func_145782_y());
        }
        compound.func_218657_a("dancer_ids", (INBT)nbt);
    }

    public int getSummonTime() {
        return (Integer)this.field_70180_af.func_187225_a(SUMMON_TIME);
    }

    public void setSummonTime(int time) {
        this.field_70180_af.func_187227_b(SUMMON_TIME, (Object)time);
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.DANCING_ZOMBIE;
    }

    static class SummonDancerGoal
    extends Goal {
        private final DancingZombieEntity dancer;

        public SummonDancerGoal(DancingZombieEntity dancer) {
            this.dancer = dancer;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            if (this.dancer.summonCnt >= this.dancer.getMaxSummonCnt()) {
                return false;
            }
            if (this.dancer.getSummonTime() > 0) {
                return true;
            }
            if (this.dancer.restTick > 0 && this.dancer.hasEmptyPlace() && this.dancer.func_70681_au().nextFloat() < 0.05f) {
                this.dancer.setSummonTime(10);
                return true;
            }
            return false;
        }

        public void func_75249_e() {
            this.dancer.updateSpeed();
        }

        public boolean func_75253_b() {
            return this.dancer.getSummonTime() > 0;
        }

        public void func_75246_d() {
            int tick = this.dancer.getSummonTime();
            if (tick == 5) {
                this.dancer.summonEmptyDancers();
            }
            this.dancer.setSummonTime(Math.max(0, tick - 1));
        }

        public void func_75251_c() {
            this.dancer.updateSpeed();
        }
    }

    static class ZombieDanceGoal
    extends Goal {
        private final DancingZombieEntity dancer;

        public ZombieDanceGoal(DancingZombieEntity dancer) {
            this.dancer = dancer;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            if (this.dancer.getAttackTime() > 0) {
                return true;
            }
            if (this.dancer.restTick > 0) {
                --this.dancer.restTick;
                return false;
            }
            if (this.dancer.func_70681_au().nextFloat() < 0.05f) {
                this.dancer.setAttackTime(100);
                return true;
            }
            return false;
        }

        public void func_75249_e() {
            this.dancer.updateSpeed();
        }

        public boolean func_75253_b() {
            return this.dancer.getAttackTime() > 0;
        }

        public void func_75246_d() {
            int tick = this.dancer.getAttackTime();
            if (tick == 1) {
                this.dancer.setRestTick();
            }
            this.dancer.tickDance();
            this.dancer.setAttackTime(Math.max(0, tick - 1));
        }

        public void func_75251_c() {
            this.dancer.updateSpeed();
        }
    }
}

