/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.zombie.grassnight;

import com.hungteen.pvz.common.entity.zombie.grassnight.FootballZombieEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.data.loot.PVZLoot;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.MathUtil;
import com.hungteen.pvz.utils.enums.MetalTypes;
import com.hungteen.pvz.utils.enums.Zombies;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class GigaFootballZombieEntity
extends FootballZombieEntity {
    private static final float GIGA_HEALTH = 300.0f;
    protected boolean isRushing = false;
    private final int minRushCD = 200;
    private final int maxRushCD = 600;

    public GigaFootballZombieEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.canCollideWithZombie = false;
    }

    @Override
    protected void updateAttributes() {
        super.updateAttributes();
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(10.0);
    }

    @Override
    public void increaseMetal() {
        this.setDefenceLife(300.0f);
    }

    @Override
    public MetalTypes getMetalType() {
        return MetalTypes.GIGA_HELMET;
    }

    @Override
    public void normalZombieTick() {
        super.normalZombieTick();
        if (!this.field_70170_p.field_72995_K) {
            if (!this.isRushing && this.getAttackTime() == 0) {
                this.updateRush(true);
            }
            this.setAttackTime(Math.max(0, this.getAttackTime() - 1));
        }
    }

    protected void updateRush(boolean is) {
        this.isRushing = is;
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(is ? (double)0.3f : 0.25);
        if (!is) {
            this.setAttackTime(MathUtil.getRandomMinMax(this.func_70681_au(), 200, 600));
        }
    }

    @Override
    protected boolean shouldCollideWithEntity(LivingEntity target) {
        return EntityUtil.canTargetEntity((Entity)this, (Entity)target);
    }

    protected void func_82167_n(Entity target) {
        if (this.isRushing() && target instanceof LivingEntity) {
            target.func_70097_a((DamageSource)PVZDamageSource.causeCrushDamage((Entity)this), EntityUtil.getMaxHealthDamage((LivingEntity)target));
            this.updateRush(false);
        }
    }

    @Override
    protected double getCollideWidthOffset() {
        return 0.4;
    }

    @Override
    public boolean canBeCold() {
        return !this.isRushing();
    }

    @Override
    public boolean canBeButter() {
        return !this.isRushing();
    }

    public boolean isRushing() {
        return this.isRushing;
    }

    @Override
    public float getLife() {
        return 100.0f;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("is_zombie_rushing")) {
            this.isRushing = compound.func_74767_n("is_zombie_rushing");
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("is_zombie_rushing", this.isRushing);
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return PVZLoot.GIGA_FOOTBALL_ZOMBIE;
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.GIGA_FOOTBALL_ZOMBIE;
    }
}

