/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.zombie.grassnight;

import com.hungteen.pvz.common.entity.zombie.base.DefenceZombieEntity;
import com.hungteen.pvz.common.entity.zombie.body.ZombieDropBodyEntity;
import com.hungteen.pvz.common.entity.zombie.part.PVZHealthPartEntity;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Zombies;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class NewspaperZombieEntity
extends DefenceZombieEntity {
    public NewspaperZombieEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void updateAttributes() {
        super.updateAttributes();
        this.updateAngry(false);
    }

    @Override
    public void resetParts() {
        this.removeParts();
        this.part = new PVZHealthPartEntity(this, 1.0f, 1.0f);
        this.part.setOwner((LivingEntity)this);
    }

    @Override
    protected float getPartHeightOffset() {
        if (this.isMiniZombie()) {
            return 0.2f;
        }
        return 0.7f;
    }

    public void func_184206_a(DataParameter<?> data) {
        super.func_184206_a(data);
        if (data.equals((Object)DEFENCE_LIFE)) {
            this.updateAngry(this.isAngry());
            if (this.isAngry()) {
                EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.ANGRY.get());
            }
        }
    }

    protected void updateAngry(boolean is) {
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(is ? (double)0.225f : (double)0.19f);
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(is ? 6.0 : 8.0);
    }

    @Override
    public boolean canLostHand() {
        return super.canLostHand() && this.isAngry();
    }

    @Override
    protected void setBodyStates(ZombieDropBodyEntity body) {
        super.setBodyStates(body);
        body.setHandDefence(!this.isAngry());
    }

    @Override
    public SoundEvent getPartDeathSound() {
        return (SoundEvent)SoundRegister.PAPER_GONE.get();
    }

    @Override
    public float getLife() {
        return 22.0f;
    }

    @Override
    public float getPartLife() {
        return 10.0f;
    }

    public boolean isAngry() {
        return this.getDefenceLife() == 0.0f;
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.NEWSPAPER_ZOMBIE;
    }
}

