/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.zombie.grassnight;

import com.hungteen.pvz.common.cache.InvasionCache;
import com.hungteen.pvz.common.entity.plant.assist.GraveBusterEntity;
import com.hungteen.pvz.common.entity.zombie.grassnight.AbstractTombStoneEntity;
import com.hungteen.pvz.common.entity.zombie.other.NobleZombieEntity;
import com.hungteen.pvz.common.entity.zombie.roof.ZomBossEntity;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.MathUtil;
import com.hungteen.pvz.utils.ZombieUtil;
import com.hungteen.pvz.utils.enums.Zombies;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class TombStoneEntity
extends AbstractTombStoneEntity {
    protected int waveSummonTick = 0;
    protected int currentSummonCD;
    private final int MinSummonCD = 360;
    private final int MaxSummonCD = 1200;

    public TombStoneEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new TombStoneSummonZombieGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new NearestAttackableTargetGoal((MobEntity)this, NobleZombieEntity.class, true));
        this.field_70715_bh.func_75776_a(0, (Goal)new NearestAttackableTargetGoal((MobEntity)this, ZomBossEntity.class, true));
    }

    public void activateByWave() {
        this.waveSummonTick = 40;
    }

    public static void spawnTombStone(World world, BlockPos pos) {
        TombStoneEntity tomb = (TombStoneEntity)((EntityType)EntityRegister.TOMB_STONE.get()).func_200721_a(world);
        tomb.setZombieRising();
        EntityUtil.onEntitySpawn((IWorld)world, (Entity)tomb, pos);
    }

    @Override
    public void normalZombieTick() {
        super.normalZombieTick();
        if (!this.field_70170_p.field_72995_K && this.waveSummonTick > 0) {
            --this.waveSummonTick;
            if (this.waveSummonTick == 1) {
                this.summonZombie();
            }
        }
    }

    public void summonZombie() {
        List<Zombies> list = InvasionCache.getOrDefaultZombieList(Zombies.DEFAULT_ZOMBIES);
        Zombies zombieType = list.get(this.field_70146_Z.nextInt(list.size()));
        Optional.ofNullable(ZombieUtil.getZombieEntity(this.field_70170_p, zombieType)).ifPresent(zombie -> {
            zombie.setZombieRising();
            ZombieUtil.copySummonZombieData(this, zombie);
            EntityUtil.onEntitySpawn((IWorld)this.field_70170_p, (Entity)zombie, this.func_233580_cy_());
        });
    }

    protected boolean canSummonZombie() {
        return EntityUtil.isEntityValid((Entity)this.func_70638_az());
    }

    @Override
    protected boolean isZombieInvulnerableTo(DamageSource source) {
        return super.isZombieInvulnerableTo(source) || !(source.func_76364_f() instanceof GraveBusterEntity);
    }

    protected int genSummonCD() {
        return MathUtil.getRandomMinMax(this.func_70681_au(), 360, 1200);
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.TOMB_STONE;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("wave_summon_tick")) {
            this.waveSummonTick = compound.func_74762_e("wave_summon_tick");
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("wave_summon_tick", this.waveSummonTick);
    }

    static class TombStoneSummonZombieGoal
    extends Goal {
        protected final TombStoneEntity tomb;

        public TombStoneSummonZombieGoal(TombStoneEntity tomb) {
            this.tomb = tomb;
        }

        public boolean func_75250_a() {
            if (this.tomb.getAttackTime() > 0) {
                return true;
            }
            if (this.tomb.field_70146_Z.nextInt(10) == 0 && this.tomb.canSummonZombie()) {
                this.tomb.setAttackTime(1);
                this.tomb.currentSummonCD = this.tomb.genSummonCD();
                return true;
            }
            return false;
        }

        public void func_75249_e() {
        }

        public boolean func_75253_b() {
            return this.tomb.getAttackTime() > 0 && this.tomb.canSummonZombie();
        }

        public void func_75246_d() {
            int time = this.tomb.getAttackTime();
            if (time >= this.tomb.currentSummonCD) {
                this.tomb.summonZombie();
                this.tomb.setAttackTime(0);
            } else {
                this.tomb.setAttackTime(time + 1);
            }
        }

        public void func_75251_c() {
            this.tomb.setAttackTime(0);
        }
    }
}

