/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.zombie.other;

import com.hungteen.pvz.common.entity.misc.ZombieHandEntity;
import com.hungteen.pvz.common.entity.zombie.base.AbstractBossZombieEntity;
import com.hungteen.pvz.common.entity.zombie.other.MournerZombieEntity;
import com.hungteen.pvz.common.entity.zombie.other.NobleZombieEntity;
import com.hungteen.pvz.data.loot.PVZLoot;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Zombies;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class CoffinEntity
extends AbstractBossZombieEntity {
    private static final DataParameter<Integer> GUARD_STATE = EntityDataManager.func_187226_a(CoffinEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public CoffinEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.setIsWholeBody();
        this.maxDeathTime = 0;
        this.kickRange = 3.0f;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(GUARD_STATE, (Object)0);
    }

    @Override
    protected void updateAttributes() {
        super.updateAttributes();
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(8.0);
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.18f);
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        if (!this.field_70170_p.field_72995_K) {
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.DIRT_RISE.get());
            ZombieHandEntity.spawnRangeZombieHands(this.field_70170_p, this, 3);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    public void zombieTick() {
        super.zombieTick();
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            for (int i = 0; i < 4; ++i) {
                if (this.isGuardGone(i) || !(this.bossInfo.func_186738_f() < (float)(5 - i) * 1.0f / 6.0f)) continue;
                this.setGuardStateById(i, 1);
                MournerZombieEntity zombie = (MournerZombieEntity)((EntityType)EntityRegister.MOURNER_ZOMBIE.get()).func_200721_a(this.field_70170_p);
                zombie.setRightShake((i & 1) == 0);
                this.onBossSummon(zombie, this.func_70638_az() == null ? this.func_233580_cy_() : this.func_70638_az().func_233580_cy_());
            }
        }
    }

    @Override
    protected void onZombieRemove() {
        if (!this.field_70170_p.field_72995_K) {
            NobleZombieEntity boss = (NobleZombieEntity)((EntityType)EntityRegister.NOBLE_ZOMBIE.get()).func_200721_a(this.field_70170_p);
            this.onBossSummon(boss, this.func_233580_cy_().func_177984_a());
        }
    }

    @Override
    protected double getCollideWidthOffset() {
        return 0.5;
    }

    @Override
    public float getLife() {
        return 1000.0f;
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)2.0f, (float)2.0f);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("guard_state")) {
            this.setGuardState(compound.func_74762_e("guard_state"));
        }
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("guard_state", this.getGuardState());
    }

    public int getGuardState() {
        return (Integer)this.field_70180_af.func_187225_a(GUARD_STATE);
    }

    public void setGuardState(int state) {
        this.field_70180_af.func_187227_b(GUARD_STATE, (Object)state);
    }

    public boolean isGuardGone(int id) {
        return (this.getGuardState() >> id & 1) == 1;
    }

    public void setGuardStateById(int id, int is) {
        int state = this.getGuardState();
        if ((is ^ state >> id & 1) == 1) {
            state ^= 1 << id;
        }
        this.field_70180_af.func_187227_b(GUARD_STATE, (Object)state);
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return PVZLoot.COFFIN;
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.COFFIN;
    }
}

