/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.zombie.other;

import com.hungteen.pvz.common.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.common.entity.zombie.grassnight.TombStoneEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.data.loot.PVZLoot;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.ZombieUtil;
import com.hungteen.pvz.utils.enums.Zombies;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class MournerZombieEntity
extends PVZZombieEntity {
    private static final DataParameter<Boolean> RIGHT_SHAKE = EntityDataManager.func_187226_a(MournerZombieEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final int SHAKE_CD = 10;

    public MournerZombieEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.setRightShake(this.func_70681_au().nextInt(2) == 0);
        this.maxDeathTime = 0;
        this.canLostHand = false;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(RIGHT_SHAKE, (Object)true);
    }

    @Override
    protected void updateAttributes() {
        super.updateAttributes();
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.19f);
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(4.0);
    }

    @Override
    public float getLife() {
        return 48.0f;
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        this.setAttackTime(10);
        float scale = 3.0f;
        if (!entityIn.func_233570_aj_() && entityIn instanceof LivingEntity) {
            entityIn.func_70097_a((DamageSource)PVZDamageSource.normal((Entity)this), EntityUtil.getMaxHealthDamage((LivingEntity)entityIn, 0.2f));
        }
        entityIn.func_213293_j(0.0, Math.sqrt(this.func_70681_au().nextFloat()) * 3.0, 0.0);
        return super.func_70652_k(entityIn);
    }

    @Override
    protected PVZDamageSource getZombieAttackDamageSource() {
        return PVZDamageSource.normal((Entity)this);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getAttackTime() > 0) {
            this.setAttackTime(this.getAttackTime() - 1);
        }
    }

    @Override
    protected void onZombieRemove() {
        if (!this.field_70170_p.field_72995_K) {
            TombStoneEntity tomb = (TombStoneEntity)((EntityType)EntityRegister.TOMB_STONE.get()).func_200721_a(this.field_70170_p);
            ZombieUtil.onZombieSpawn(this, tomb, this.func_233580_cy_());
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("is_right_shake")) {
            this.setRightShake(compound.func_74767_n("is_right_shake"));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("is_right_shake", this.isRightShake());
    }

    public boolean isRightShake() {
        return (Boolean)this.field_70180_af.func_187225_a(RIGHT_SHAKE);
    }

    public void setRightShake(boolean is) {
        this.field_70180_af.func_187227_b(RIGHT_SHAKE, (Object)is);
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return PVZLoot.MOURNER_ZOMBIE;
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.MOURNER_ZOMBIE;
    }
}

